/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProvisioningTemplateVersionsResponse extends IotResponse implements
        ToCopyableBuilder<ListProvisioningTemplateVersionsResponse.Builder, ListProvisioningTemplateVersionsResponse> {
    private static final SdkField<List<ProvisioningTemplateVersionSummary>> VERSIONS_FIELD = SdkField
            .<List<ProvisioningTemplateVersionSummary>> builder(MarshallingType.LIST)
            .memberName("versions")
            .getter(getter(ListProvisioningTemplateVersionsResponse::versions))
            .setter(setter(Builder::versions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningTemplateVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningTemplateVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProvisioningTemplateVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ProvisioningTemplateVersionSummary> versions;

    private final String nextToken;

    private ListProvisioningTemplateVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.versions = builder.versions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Versions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVersions() {
        return versions != null && !(versions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of fleet provisioning template versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVersions} method.
     * </p>
     * 
     * @return The list of fleet provisioning template versions.
     */
    public final List<ProvisioningTemplateVersionSummary> versions() {
        return versions;
    }

    /**
     * <p>
     * A token to retrieve the next set of results.
     * </p>
     * 
     * @return A token to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVersions() ? versions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisioningTemplateVersionsResponse)) {
            return false;
        }
        ListProvisioningTemplateVersionsResponse other = (ListProvisioningTemplateVersionsResponse) obj;
        return hasVersions() == other.hasVersions() && Objects.equals(versions(), other.versions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProvisioningTemplateVersionsResponse").add("Versions", hasVersions() ? versions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "versions":
            return Optional.ofNullable(clazz.cast(versions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProvisioningTemplateVersionsResponse, T> g) {
        return obj -> g.apply((ListProvisioningTemplateVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProvisioningTemplateVersionsResponse> {
        /**
         * <p>
         * The list of fleet provisioning template versions.
         * </p>
         * 
         * @param versions
         *        The list of fleet provisioning template versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<ProvisioningTemplateVersionSummary> versions);

        /**
         * <p>
         * The list of fleet provisioning template versions.
         * </p>
         * 
         * @param versions
         *        The list of fleet provisioning template versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(ProvisioningTemplateVersionSummary... versions);

        /**
         * <p>
         * The list of fleet provisioning template versions.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ProvisioningTemplateVersionSummary>.Builder} avoiding the need to create one manually via {@link List
         * <ProvisioningTemplateVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProvisioningTemplateVersionSummary>.Builder#build()} is
         * called immediately and its result is passed to {@link #versions(List<ProvisioningTemplateVersionSummary>)}.
         * 
         * @param versions
         *        a consumer that will call methods on {@link List<ProvisioningTemplateVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versions(List<ProvisioningTemplateVersionSummary>)
         */
        Builder versions(Consumer<ProvisioningTemplateVersionSummary.Builder>... versions);

        /**
         * <p>
         * A token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<ProvisioningTemplateVersionSummary> versions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisioningTemplateVersionsResponse model) {
            super(model);
            versions(model.versions);
            nextToken(model.nextToken);
        }

        public final List<ProvisioningTemplateVersionSummary.Builder> getVersions() {
            List<ProvisioningTemplateVersionSummary.Builder> result = ProvisioningTemplateVersionListingCopier
                    .copyToBuilder(this.versions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVersions(Collection<ProvisioningTemplateVersionSummary.BuilderImpl> versions) {
            this.versions = ProvisioningTemplateVersionListingCopier.copyFromBuilder(versions);
        }

        @Override
        @Transient
        public final Builder versions(Collection<ProvisioningTemplateVersionSummary> versions) {
            this.versions = ProvisioningTemplateVersionListingCopier.copy(versions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder versions(ProvisioningTemplateVersionSummary... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder versions(Consumer<ProvisioningTemplateVersionSummary.Builder>... versions) {
            versions(Stream.of(versions).map(c -> ProvisioningTemplateVersionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProvisioningTemplateVersionsResponse build() {
            return new ListProvisioningTemplateVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
