/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAuditFindingResponse extends IotResponse implements
        ToCopyableBuilder<DescribeAuditFindingResponse.Builder, DescribeAuditFindingResponse> {
    private static final SdkField<AuditFinding> FINDING_FIELD = SdkField.<AuditFinding> builder(MarshallingType.SDK_POJO)
            .memberName("finding").getter(getter(DescribeAuditFindingResponse::finding)).setter(setter(Builder::finding))
            .constructor(AuditFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finding").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_FIELD));

    private final AuditFinding finding;

    private DescribeAuditFindingResponse(BuilderImpl builder) {
        super(builder);
        this.finding = builder.finding;
    }

    /**
     * Returns the value of the Finding property for this object.
     * 
     * @return The value of the Finding property for this object.
     */
    public final AuditFinding finding() {
        return finding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(finding());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAuditFindingResponse)) {
            return false;
        }
        DescribeAuditFindingResponse other = (DescribeAuditFindingResponse) obj;
        return Objects.equals(finding(), other.finding());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAuditFindingResponse").add("Finding", finding()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "finding":
            return Optional.ofNullable(clazz.cast(finding()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAuditFindingResponse, T> g) {
        return obj -> g.apply((DescribeAuditFindingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAuditFindingResponse> {
        /**
         * Sets the value of the Finding property for this object.
         *
         * @param finding
         *        The new value for the Finding property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finding(AuditFinding finding);

        /**
         * Sets the value of the Finding property for this object.
         *
         * This is a convenience that creates an instance of the {@link AuditFinding.Builder} avoiding the need to
         * create one manually via {@link AuditFinding#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuditFinding.Builder#build()} is called immediately and its
         * result is passed to {@link #finding(AuditFinding)}.
         * 
         * @param finding
         *        a consumer that will call methods on {@link AuditFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finding(AuditFinding)
         */
        default Builder finding(Consumer<AuditFinding.Builder> finding) {
            return finding(AuditFinding.builder().applyMutation(finding).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private AuditFinding finding;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAuditFindingResponse model) {
            super(model);
            finding(model.finding);
        }

        public final AuditFinding.Builder getFinding() {
            return finding != null ? finding.toBuilder() : null;
        }

        public final void setFinding(AuditFinding.BuilderImpl finding) {
            this.finding = finding != null ? finding.build() : null;
        }

        @Override
        @Transient
        public final Builder finding(AuditFinding finding) {
            this.finding = finding;
            return this;
        }

        @Override
        public DescribeAuditFindingResponse build() {
            return new DescribeAuditFindingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
