/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an active Device Defender security profile behavior violation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveViolation implements SdkPojo, Serializable, ToCopyableBuilder<ActiveViolation.Builder, ActiveViolation> {
    private static final SdkField<String> VIOLATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("violationId").getter(getter(ActiveViolation::violationId)).setter(setter(Builder::violationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationId").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(ActiveViolation::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileName").getter(getter(ActiveViolation::securityProfileName))
            .setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build())
            .build();

    private static final SdkField<Behavior> BEHAVIOR_FIELD = SdkField.<Behavior> builder(MarshallingType.SDK_POJO)
            .memberName("behavior").getter(getter(ActiveViolation::behavior)).setter(setter(Builder::behavior))
            .constructor(Behavior::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()).build();

    private static final SdkField<MetricValue> LAST_VIOLATION_VALUE_FIELD = SdkField
            .<MetricValue> builder(MarshallingType.SDK_POJO).memberName("lastViolationValue")
            .getter(getter(ActiveViolation::lastViolationValue)).setter(setter(Builder::lastViolationValue))
            .constructor(MetricValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastViolationValue").build())
            .build();

    private static final SdkField<ViolationEventAdditionalInfo> VIOLATION_EVENT_ADDITIONAL_INFO_FIELD = SdkField
            .<ViolationEventAdditionalInfo> builder(MarshallingType.SDK_POJO)
            .memberName("violationEventAdditionalInfo")
            .getter(getter(ActiveViolation::violationEventAdditionalInfo))
            .setter(setter(Builder::violationEventAdditionalInfo))
            .constructor(ViolationEventAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventAdditionalInfo")
                    .build()).build();

    private static final SdkField<String> VERIFICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("verificationState").getter(getter(ActiveViolation::verificationStateAsString))
            .setter(setter(Builder::verificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationState").build()).build();

    private static final SdkField<String> VERIFICATION_STATE_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("verificationStateDescription")
            .getter(getter(ActiveViolation::verificationStateDescription))
            .setter(setter(Builder::verificationStateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationStateDescription")
                    .build()).build();

    private static final SdkField<Instant> LAST_VIOLATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastViolationTime").getter(getter(ActiveViolation::lastViolationTime))
            .setter(setter(Builder::lastViolationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastViolationTime").build()).build();

    private static final SdkField<Instant> VIOLATION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("violationStartTime").getter(getter(ActiveViolation::violationStartTime))
            .setter(setter(Builder::violationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationStartTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_ID_FIELD,
            THING_NAME_FIELD, SECURITY_PROFILE_NAME_FIELD, BEHAVIOR_FIELD, LAST_VIOLATION_VALUE_FIELD,
            VIOLATION_EVENT_ADDITIONAL_INFO_FIELD, VERIFICATION_STATE_FIELD, VERIFICATION_STATE_DESCRIPTION_FIELD,
            LAST_VIOLATION_TIME_FIELD, VIOLATION_START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String violationId;

    private final String thingName;

    private final String securityProfileName;

    private final Behavior behavior;

    private final MetricValue lastViolationValue;

    private final ViolationEventAdditionalInfo violationEventAdditionalInfo;

    private final String verificationState;

    private final String verificationStateDescription;

    private final Instant lastViolationTime;

    private final Instant violationStartTime;

    private ActiveViolation(BuilderImpl builder) {
        this.violationId = builder.violationId;
        this.thingName = builder.thingName;
        this.securityProfileName = builder.securityProfileName;
        this.behavior = builder.behavior;
        this.lastViolationValue = builder.lastViolationValue;
        this.violationEventAdditionalInfo = builder.violationEventAdditionalInfo;
        this.verificationState = builder.verificationState;
        this.verificationStateDescription = builder.verificationStateDescription;
        this.lastViolationTime = builder.lastViolationTime;
        this.violationStartTime = builder.violationStartTime;
    }

    /**
     * <p>
     * The ID of the active violation.
     * </p>
     * 
     * @return The ID of the active violation.
     */
    public final String violationId() {
        return violationId;
    }

    /**
     * <p>
     * The name of the thing responsible for the active violation.
     * </p>
     * 
     * @return The name of the thing responsible for the active violation.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The security profile with the behavior is in violation.
     * </p>
     * 
     * @return The security profile with the behavior is in violation.
     */
    public final String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * The behavior that is being violated.
     * </p>
     * 
     * @return The behavior that is being violated.
     */
    public final Behavior behavior() {
        return behavior;
    }

    /**
     * <p>
     * The value of the metric (the measurement) that caused the most recent violation.
     * </p>
     * 
     * @return The value of the metric (the measurement) that caused the most recent violation.
     */
    public final MetricValue lastViolationValue() {
        return lastViolationValue;
    }

    /**
     * <p>
     * The details of a violation event.
     * </p>
     * 
     * @return The details of a violation event.
     */
    public final ViolationEventAdditionalInfo violationEventAdditionalInfo() {
        return violationEventAdditionalInfo;
    }

    /**
     * <p>
     * The verification state of the violation (detect alarm).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return The verification state of the violation (detect alarm).
     * @see VerificationState
     */
    public final VerificationState verificationState() {
        return VerificationState.fromValue(verificationState);
    }

    /**
     * <p>
     * The verification state of the violation (detect alarm).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return The verification state of the violation (detect alarm).
     * @see VerificationState
     */
    public final String verificationStateAsString() {
        return verificationState;
    }

    /**
     * <p>
     * The description of the verification state of the violation.
     * </p>
     * 
     * @return The description of the verification state of the violation.
     */
    public final String verificationStateDescription() {
        return verificationStateDescription;
    }

    /**
     * <p>
     * The time the most recent violation occurred.
     * </p>
     * 
     * @return The time the most recent violation occurred.
     */
    public final Instant lastViolationTime() {
        return lastViolationTime;
    }

    /**
     * <p>
     * The time the violation started.
     * </p>
     * 
     * @return The time the violation started.
     */
    public final Instant violationStartTime() {
        return violationStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationId());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(behavior());
        hashCode = 31 * hashCode + Objects.hashCode(lastViolationValue());
        hashCode = 31 * hashCode + Objects.hashCode(violationEventAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(verificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(verificationStateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(lastViolationTime());
        hashCode = 31 * hashCode + Objects.hashCode(violationStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveViolation)) {
            return false;
        }
        ActiveViolation other = (ActiveViolation) obj;
        return Objects.equals(violationId(), other.violationId()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(behavior(), other.behavior())
                && Objects.equals(lastViolationValue(), other.lastViolationValue())
                && Objects.equals(violationEventAdditionalInfo(), other.violationEventAdditionalInfo())
                && Objects.equals(verificationStateAsString(), other.verificationStateAsString())
                && Objects.equals(verificationStateDescription(), other.verificationStateDescription())
                && Objects.equals(lastViolationTime(), other.lastViolationTime())
                && Objects.equals(violationStartTime(), other.violationStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActiveViolation").add("ViolationId", violationId()).add("ThingName", thingName())
                .add("SecurityProfileName", securityProfileName()).add("Behavior", behavior())
                .add("LastViolationValue", lastViolationValue())
                .add("ViolationEventAdditionalInfo", violationEventAdditionalInfo())
                .add("VerificationState", verificationStateAsString())
                .add("VerificationStateDescription", verificationStateDescription())
                .add("LastViolationTime", lastViolationTime()).add("ViolationStartTime", violationStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "violationId":
            return Optional.ofNullable(clazz.cast(violationId()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "behavior":
            return Optional.ofNullable(clazz.cast(behavior()));
        case "lastViolationValue":
            return Optional.ofNullable(clazz.cast(lastViolationValue()));
        case "violationEventAdditionalInfo":
            return Optional.ofNullable(clazz.cast(violationEventAdditionalInfo()));
        case "verificationState":
            return Optional.ofNullable(clazz.cast(verificationStateAsString()));
        case "verificationStateDescription":
            return Optional.ofNullable(clazz.cast(verificationStateDescription()));
        case "lastViolationTime":
            return Optional.ofNullable(clazz.cast(lastViolationTime()));
        case "violationStartTime":
            return Optional.ofNullable(clazz.cast(violationStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActiveViolation, T> g) {
        return obj -> g.apply((ActiveViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveViolation> {
        /**
         * <p>
         * The ID of the active violation.
         * </p>
         * 
         * @param violationId
         *        The ID of the active violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationId(String violationId);

        /**
         * <p>
         * The name of the thing responsible for the active violation.
         * </p>
         * 
         * @param thingName
         *        The name of the thing responsible for the active violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The security profile with the behavior is in violation.
         * </p>
         * 
         * @param securityProfileName
         *        The security profile with the behavior is in violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * The behavior that is being violated.
         * </p>
         * 
         * @param behavior
         *        The behavior that is being violated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behavior(Behavior behavior);

        /**
         * <p>
         * The behavior that is being violated.
         * </p>
         * This is a convenience that creates an instance of the {@link Behavior.Builder} avoiding the need to create
         * one manually via {@link Behavior#builder()}.
         *
         * When the {@link Consumer} completes, {@link Behavior.Builder#build()} is called immediately and its result is
         * passed to {@link #behavior(Behavior)}.
         * 
         * @param behavior
         *        a consumer that will call methods on {@link Behavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #behavior(Behavior)
         */
        default Builder behavior(Consumer<Behavior.Builder> behavior) {
            return behavior(Behavior.builder().applyMutation(behavior).build());
        }

        /**
         * <p>
         * The value of the metric (the measurement) that caused the most recent violation.
         * </p>
         * 
         * @param lastViolationValue
         *        The value of the metric (the measurement) that caused the most recent violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastViolationValue(MetricValue lastViolationValue);

        /**
         * <p>
         * The value of the metric (the measurement) that caused the most recent violation.
         * </p>
         * This is a convenience that creates an instance of the {@link MetricValue.Builder} avoiding the need to create
         * one manually via {@link MetricValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricValue.Builder#build()} is called immediately and its result
         * is passed to {@link #lastViolationValue(MetricValue)}.
         * 
         * @param lastViolationValue
         *        a consumer that will call methods on {@link MetricValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastViolationValue(MetricValue)
         */
        default Builder lastViolationValue(Consumer<MetricValue.Builder> lastViolationValue) {
            return lastViolationValue(MetricValue.builder().applyMutation(lastViolationValue).build());
        }

        /**
         * <p>
         * The details of a violation event.
         * </p>
         * 
         * @param violationEventAdditionalInfo
         *        The details of a violation event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationEventAdditionalInfo(ViolationEventAdditionalInfo violationEventAdditionalInfo);

        /**
         * <p>
         * The details of a violation event.
         * </p>
         * This is a convenience that creates an instance of the {@link ViolationEventAdditionalInfo.Builder} avoiding
         * the need to create one manually via {@link ViolationEventAdditionalInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ViolationEventAdditionalInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #violationEventAdditionalInfo(ViolationEventAdditionalInfo)}.
         * 
         * @param violationEventAdditionalInfo
         *        a consumer that will call methods on {@link ViolationEventAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violationEventAdditionalInfo(ViolationEventAdditionalInfo)
         */
        default Builder violationEventAdditionalInfo(Consumer<ViolationEventAdditionalInfo.Builder> violationEventAdditionalInfo) {
            return violationEventAdditionalInfo(ViolationEventAdditionalInfo.builder()
                    .applyMutation(violationEventAdditionalInfo).build());
        }

        /**
         * <p>
         * The verification state of the violation (detect alarm).
         * </p>
         * 
         * @param verificationState
         *        The verification state of the violation (detect alarm).
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(String verificationState);

        /**
         * <p>
         * The verification state of the violation (detect alarm).
         * </p>
         * 
         * @param verificationState
         *        The verification state of the violation (detect alarm).
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(VerificationState verificationState);

        /**
         * <p>
         * The description of the verification state of the violation.
         * </p>
         * 
         * @param verificationStateDescription
         *        The description of the verification state of the violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationStateDescription(String verificationStateDescription);

        /**
         * <p>
         * The time the most recent violation occurred.
         * </p>
         * 
         * @param lastViolationTime
         *        The time the most recent violation occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastViolationTime(Instant lastViolationTime);

        /**
         * <p>
         * The time the violation started.
         * </p>
         * 
         * @param violationStartTime
         *        The time the violation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationStartTime(Instant violationStartTime);
    }

    static final class BuilderImpl implements Builder {
        private String violationId;

        private String thingName;

        private String securityProfileName;

        private Behavior behavior;

        private MetricValue lastViolationValue;

        private ViolationEventAdditionalInfo violationEventAdditionalInfo;

        private String verificationState;

        private String verificationStateDescription;

        private Instant lastViolationTime;

        private Instant violationStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveViolation model) {
            violationId(model.violationId);
            thingName(model.thingName);
            securityProfileName(model.securityProfileName);
            behavior(model.behavior);
            lastViolationValue(model.lastViolationValue);
            violationEventAdditionalInfo(model.violationEventAdditionalInfo);
            verificationState(model.verificationState);
            verificationStateDescription(model.verificationStateDescription);
            lastViolationTime(model.lastViolationTime);
            violationStartTime(model.violationStartTime);
        }

        public final String getViolationId() {
            return violationId;
        }

        public final void setViolationId(String violationId) {
            this.violationId = violationId;
        }

        @Override
        @Transient
        public final Builder violationId(String violationId) {
            this.violationId = violationId;
            return this;
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        @Transient
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        @Override
        @Transient
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final Behavior.Builder getBehavior() {
            return behavior != null ? behavior.toBuilder() : null;
        }

        public final void setBehavior(Behavior.BuilderImpl behavior) {
            this.behavior = behavior != null ? behavior.build() : null;
        }

        @Override
        @Transient
        public final Builder behavior(Behavior behavior) {
            this.behavior = behavior;
            return this;
        }

        public final MetricValue.Builder getLastViolationValue() {
            return lastViolationValue != null ? lastViolationValue.toBuilder() : null;
        }

        public final void setLastViolationValue(MetricValue.BuilderImpl lastViolationValue) {
            this.lastViolationValue = lastViolationValue != null ? lastViolationValue.build() : null;
        }

        @Override
        @Transient
        public final Builder lastViolationValue(MetricValue lastViolationValue) {
            this.lastViolationValue = lastViolationValue;
            return this;
        }

        public final ViolationEventAdditionalInfo.Builder getViolationEventAdditionalInfo() {
            return violationEventAdditionalInfo != null ? violationEventAdditionalInfo.toBuilder() : null;
        }

        public final void setViolationEventAdditionalInfo(ViolationEventAdditionalInfo.BuilderImpl violationEventAdditionalInfo) {
            this.violationEventAdditionalInfo = violationEventAdditionalInfo != null ? violationEventAdditionalInfo.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder violationEventAdditionalInfo(ViolationEventAdditionalInfo violationEventAdditionalInfo) {
            this.violationEventAdditionalInfo = violationEventAdditionalInfo;
            return this;
        }

        public final String getVerificationState() {
            return verificationState;
        }

        public final void setVerificationState(String verificationState) {
            this.verificationState = verificationState;
        }

        @Override
        @Transient
        public final Builder verificationState(String verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        @Override
        @Transient
        public final Builder verificationState(VerificationState verificationState) {
            this.verificationState(verificationState == null ? null : verificationState.toString());
            return this;
        }

        public final String getVerificationStateDescription() {
            return verificationStateDescription;
        }

        public final void setVerificationStateDescription(String verificationStateDescription) {
            this.verificationStateDescription = verificationStateDescription;
        }

        @Override
        @Transient
        public final Builder verificationStateDescription(String verificationStateDescription) {
            this.verificationStateDescription = verificationStateDescription;
            return this;
        }

        public final Instant getLastViolationTime() {
            return lastViolationTime;
        }

        public final void setLastViolationTime(Instant lastViolationTime) {
            this.lastViolationTime = lastViolationTime;
        }

        @Override
        @Transient
        public final Builder lastViolationTime(Instant lastViolationTime) {
            this.lastViolationTime = lastViolationTime;
            return this;
        }

        public final Instant getViolationStartTime() {
            return violationStartTime;
        }

        public final void setViolationStartTime(Instant violationStartTime) {
            this.violationStartTime = violationStartTime;
        }

        @Override
        @Transient
        public final Builder violationStartTime(Instant violationStartTime) {
            this.violationStartTime = violationStartTime;
            return this;
        }

        @Override
        public ActiveViolation build() {
            return new ActiveViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
