/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria that determine when and how a job abort takes place.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AbortCriteria implements SdkPojo, Serializable, ToCopyableBuilder<AbortCriteria.Builder, AbortCriteria> {
    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureType").getter(getter(AbortCriteria::failureTypeAsString)).setter(setter(Builder::failureType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureType").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(AbortCriteria::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Double> THRESHOLD_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("thresholdPercentage").getter(getter(AbortCriteria::thresholdPercentage))
            .setter(setter(Builder::thresholdPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdPercentage").build())
            .build();

    private static final SdkField<Integer> MIN_NUMBER_OF_EXECUTED_THINGS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("minNumberOfExecutedThings")
            .getter(getter(AbortCriteria::minNumberOfExecutedThings)).setter(setter(Builder::minNumberOfExecutedThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minNumberOfExecutedThings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_TYPE_FIELD,
            ACTION_FIELD, THRESHOLD_PERCENTAGE_FIELD, MIN_NUMBER_OF_EXECUTED_THINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String failureType;

    private final String action;

    private final Double thresholdPercentage;

    private final Integer minNumberOfExecutedThings;

    private AbortCriteria(BuilderImpl builder) {
        this.failureType = builder.failureType;
        this.action = builder.action;
        this.thresholdPercentage = builder.thresholdPercentage;
        this.minNumberOfExecutedThings = builder.minNumberOfExecutedThings;
    }

    /**
     * <p>
     * The type of job execution failures that can initiate a job abort.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureType} will
     * return {@link JobExecutionFailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureTypeAsString}.
     * </p>
     * 
     * @return The type of job execution failures that can initiate a job abort.
     * @see JobExecutionFailureType
     */
    public final JobExecutionFailureType failureType() {
        return JobExecutionFailureType.fromValue(failureType);
    }

    /**
     * <p>
     * The type of job execution failures that can initiate a job abort.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureType} will
     * return {@link JobExecutionFailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureTypeAsString}.
     * </p>
     * 
     * @return The type of job execution failures that can initiate a job abort.
     * @see JobExecutionFailureType
     */
    public final String failureTypeAsString() {
        return failureType;
    }

    /**
     * <p>
     * The type of job action to take to initiate the job abort.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link AbortAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The type of job action to take to initiate the job abort.
     * @see AbortAction
     */
    public final AbortAction action() {
        return AbortAction.fromValue(action);
    }

    /**
     * <p>
     * The type of job action to take to initiate the job abort.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link AbortAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The type of job action to take to initiate the job abort.
     * @see AbortAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The minimum percentage of job execution failures that must occur to initiate the job abort.
     * </p>
     * <p>
     * Amazon Web Services IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99, but not
     * 10.999).
     * </p>
     * 
     * @return The minimum percentage of job execution failures that must occur to initiate the job abort.</p>
     *         <p>
     *         Amazon Web Services IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99,
     *         but not 10.999).
     */
    public final Double thresholdPercentage() {
        return thresholdPercentage;
    }

    /**
     * <p>
     * The minimum number of things which must receive job execution notifications before the job can be aborted.
     * </p>
     * 
     * @return The minimum number of things which must receive job execution notifications before the job can be
     *         aborted.
     */
    public final Integer minNumberOfExecutedThings() {
        return minNumberOfExecutedThings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(minNumberOfExecutedThings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbortCriteria)) {
            return false;
        }
        AbortCriteria other = (AbortCriteria) obj;
        return Objects.equals(failureTypeAsString(), other.failureTypeAsString())
                && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(thresholdPercentage(), other.thresholdPercentage())
                && Objects.equals(minNumberOfExecutedThings(), other.minNumberOfExecutedThings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AbortCriteria").add("FailureType", failureTypeAsString()).add("Action", actionAsString())
                .add("ThresholdPercentage", thresholdPercentage()).add("MinNumberOfExecutedThings", minNumberOfExecutedThings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failureType":
            return Optional.ofNullable(clazz.cast(failureTypeAsString()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "thresholdPercentage":
            return Optional.ofNullable(clazz.cast(thresholdPercentage()));
        case "minNumberOfExecutedThings":
            return Optional.ofNullable(clazz.cast(minNumberOfExecutedThings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AbortCriteria, T> g) {
        return obj -> g.apply((AbortCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AbortCriteria> {
        /**
         * <p>
         * The type of job execution failures that can initiate a job abort.
         * </p>
         * 
         * @param failureType
         *        The type of job execution failures that can initiate a job abort.
         * @see JobExecutionFailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionFailureType
         */
        Builder failureType(String failureType);

        /**
         * <p>
         * The type of job execution failures that can initiate a job abort.
         * </p>
         * 
         * @param failureType
         *        The type of job execution failures that can initiate a job abort.
         * @see JobExecutionFailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionFailureType
         */
        Builder failureType(JobExecutionFailureType failureType);

        /**
         * <p>
         * The type of job action to take to initiate the job abort.
         * </p>
         * 
         * @param action
         *        The type of job action to take to initiate the job abort.
         * @see AbortAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AbortAction
         */
        Builder action(String action);

        /**
         * <p>
         * The type of job action to take to initiate the job abort.
         * </p>
         * 
         * @param action
         *        The type of job action to take to initiate the job abort.
         * @see AbortAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AbortAction
         */
        Builder action(AbortAction action);

        /**
         * <p>
         * The minimum percentage of job execution failures that must occur to initiate the job abort.
         * </p>
         * <p>
         * Amazon Web Services IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99, but
         * not 10.999).
         * </p>
         * 
         * @param thresholdPercentage
         *        The minimum percentage of job execution failures that must occur to initiate the job abort.</p>
         *        <p>
         *        Amazon Web Services IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99,
         *        but not 10.999).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdPercentage(Double thresholdPercentage);

        /**
         * <p>
         * The minimum number of things which must receive job execution notifications before the job can be aborted.
         * </p>
         * 
         * @param minNumberOfExecutedThings
         *        The minimum number of things which must receive job execution notifications before the job can be
         *        aborted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minNumberOfExecutedThings(Integer minNumberOfExecutedThings);
    }

    static final class BuilderImpl implements Builder {
        private String failureType;

        private String action;

        private Double thresholdPercentage;

        private Integer minNumberOfExecutedThings;

        private BuilderImpl() {
        }

        private BuilderImpl(AbortCriteria model) {
            failureType(model.failureType);
            action(model.action);
            thresholdPercentage(model.thresholdPercentage);
            minNumberOfExecutedThings(model.minNumberOfExecutedThings);
        }

        public final String getFailureType() {
            return failureType;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        @Override
        @Transient
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        @Transient
        public final Builder failureType(JobExecutionFailureType failureType) {
            this.failureType(failureType == null ? null : failureType.toString());
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        @Transient
        public final Builder action(AbortAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Double getThresholdPercentage() {
            return thresholdPercentage;
        }

        public final void setThresholdPercentage(Double thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
        }

        @Override
        @Transient
        public final Builder thresholdPercentage(Double thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
            return this;
        }

        public final Integer getMinNumberOfExecutedThings() {
            return minNumberOfExecutedThings;
        }

        public final void setMinNumberOfExecutedThings(Integer minNumberOfExecutedThings) {
            this.minNumberOfExecutedThings = minNumberOfExecutedThings;
        }

        @Override
        @Transient
        public final Builder minNumberOfExecutedThings(Integer minNumberOfExecutedThings) {
            this.minNumberOfExecutedThings = minNumberOfExecutedThings;
            return this;
        }

        @Override
        public AbortCriteria build() {
            return new AbortCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
