/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.invoicing.model.BuyerDomain;
import software.amazon.awssdk.services.invoicing.model.Contact;
import software.amazon.awssdk.services.invoicing.model.ContactsCopier;
import software.amazon.awssdk.services.invoicing.model.EinvoiceDeliveryPreference;
import software.amazon.awssdk.services.invoicing.model.InvoicingRequest;
import software.amazon.awssdk.services.invoicing.model.ProcurementPortalName;
import software.amazon.awssdk.services.invoicing.model.ProcurementPortalPreferenceSelector;
import software.amazon.awssdk.services.invoicing.model.ResourceTag;
import software.amazon.awssdk.services.invoicing.model.ResourceTagListCopier;
import software.amazon.awssdk.services.invoicing.model.SupplierDomain;
import software.amazon.awssdk.services.invoicing.model.TestEnvPreferenceInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProcurementPortalPreferenceRequest
extends InvoicingRequest
implements ToCopyableBuilder<Builder, CreateProcurementPortalPreferenceRequest> {
    private static final SdkField<String> PROCUREMENT_PORTAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalName").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::procurementPortalNameAsString)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::procurementPortalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalName").build()}).build();
    private static final SdkField<String> BUYER_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuyerDomain").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::buyerDomainAsString)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::buyerDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerDomain").build()}).build();
    private static final SdkField<String> BUYER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuyerIdentifier").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::buyerIdentifier)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::buyerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerIdentifier").build()}).build();
    private static final SdkField<String> SUPPLIER_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupplierDomain").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::supplierDomainAsString)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::supplierDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierDomain").build()}).build();
    private static final SdkField<String> SUPPLIER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupplierIdentifier").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::supplierIdentifier)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::supplierIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierIdentifier").build()}).build();
    private static final SdkField<ProcurementPortalPreferenceSelector> SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Selector").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::selector)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::selector)).constructor(ProcurementPortalPreferenceSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selector").build()}).build();
    private static final SdkField<String> PROCUREMENT_PORTAL_SHARED_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalSharedSecret").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::procurementPortalSharedSecret)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::procurementPortalSharedSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalSharedSecret").build()}).build();
    private static final SdkField<String> PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalInstanceEndpoint").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::procurementPortalInstanceEndpoint)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::procurementPortalInstanceEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalInstanceEndpoint").build()}).build();
    private static final SdkField<TestEnvPreferenceInput> TEST_ENV_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TestEnvPreference").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::testEnvPreference)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::testEnvPreference)).constructor(TestEnvPreferenceInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestEnvPreference").build()}).build();
    private static final SdkField<Boolean> EINVOICE_DELIVERY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EinvoiceDeliveryEnabled").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::einvoiceDeliveryEnabled)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::einvoiceDeliveryEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryEnabled").build()}).build();
    private static final SdkField<EinvoiceDeliveryPreference> EINVOICE_DELIVERY_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EinvoiceDeliveryPreference").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::einvoiceDeliveryPreference)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::einvoiceDeliveryPreference)).constructor(EinvoiceDeliveryPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryPreference").build()}).build();
    private static final SdkField<Boolean> PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PurchaseOrderRetrievalEnabled").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::purchaseOrderRetrievalEnabled)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::purchaseOrderRetrievalEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalEnabled").build()}).build();
    private static final SdkField<List<Contact>> CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Contacts").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::contacts)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::contacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Contact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::resourceTags)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateProcurementPortalPreferenceRequest.getter(CreateProcurementPortalPreferenceRequest::clientToken)).setter(CreateProcurementPortalPreferenceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCUREMENT_PORTAL_NAME_FIELD, BUYER_DOMAIN_FIELD, BUYER_IDENTIFIER_FIELD, SUPPLIER_DOMAIN_FIELD, SUPPLIER_IDENTIFIER_FIELD, SELECTOR_FIELD, PROCUREMENT_PORTAL_SHARED_SECRET_FIELD, PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD, TEST_ENV_PREFERENCE_FIELD, EINVOICE_DELIVERY_ENABLED_FIELD, EINVOICE_DELIVERY_PREFERENCE_FIELD, PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD, CONTACTS_FIELD, RESOURCE_TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProcurementPortalPreferenceRequest.memberNameToFieldInitializer();
    private final String procurementPortalName;
    private final String buyerDomain;
    private final String buyerIdentifier;
    private final String supplierDomain;
    private final String supplierIdentifier;
    private final ProcurementPortalPreferenceSelector selector;
    private final String procurementPortalSharedSecret;
    private final String procurementPortalInstanceEndpoint;
    private final TestEnvPreferenceInput testEnvPreference;
    private final Boolean einvoiceDeliveryEnabled;
    private final EinvoiceDeliveryPreference einvoiceDeliveryPreference;
    private final Boolean purchaseOrderRetrievalEnabled;
    private final List<Contact> contacts;
    private final List<ResourceTag> resourceTags;
    private final String clientToken;

    private CreateProcurementPortalPreferenceRequest(BuilderImpl builder) {
        super(builder);
        this.procurementPortalName = builder.procurementPortalName;
        this.buyerDomain = builder.buyerDomain;
        this.buyerIdentifier = builder.buyerIdentifier;
        this.supplierDomain = builder.supplierDomain;
        this.supplierIdentifier = builder.supplierIdentifier;
        this.selector = builder.selector;
        this.procurementPortalSharedSecret = builder.procurementPortalSharedSecret;
        this.procurementPortalInstanceEndpoint = builder.procurementPortalInstanceEndpoint;
        this.testEnvPreference = builder.testEnvPreference;
        this.einvoiceDeliveryEnabled = builder.einvoiceDeliveryEnabled;
        this.einvoiceDeliveryPreference = builder.einvoiceDeliveryPreference;
        this.purchaseOrderRetrievalEnabled = builder.purchaseOrderRetrievalEnabled;
        this.contacts = builder.contacts;
        this.resourceTags = builder.resourceTags;
        this.clientToken = builder.clientToken;
    }

    public final ProcurementPortalName procurementPortalName() {
        return ProcurementPortalName.fromValue(this.procurementPortalName);
    }

    public final String procurementPortalNameAsString() {
        return this.procurementPortalName;
    }

    public final BuyerDomain buyerDomain() {
        return BuyerDomain.fromValue(this.buyerDomain);
    }

    public final String buyerDomainAsString() {
        return this.buyerDomain;
    }

    public final String buyerIdentifier() {
        return this.buyerIdentifier;
    }

    public final SupplierDomain supplierDomain() {
        return SupplierDomain.fromValue(this.supplierDomain);
    }

    public final String supplierDomainAsString() {
        return this.supplierDomain;
    }

    public final String supplierIdentifier() {
        return this.supplierIdentifier;
    }

    public final ProcurementPortalPreferenceSelector selector() {
        return this.selector;
    }

    public final String procurementPortalSharedSecret() {
        return this.procurementPortalSharedSecret;
    }

    public final String procurementPortalInstanceEndpoint() {
        return this.procurementPortalInstanceEndpoint;
    }

    public final TestEnvPreferenceInput testEnvPreference() {
        return this.testEnvPreference;
    }

    public final Boolean einvoiceDeliveryEnabled() {
        return this.einvoiceDeliveryEnabled;
    }

    public final EinvoiceDeliveryPreference einvoiceDeliveryPreference() {
        return this.einvoiceDeliveryPreference;
    }

    public final Boolean purchaseOrderRetrievalEnabled() {
        return this.purchaseOrderRetrievalEnabled;
    }

    public final boolean hasContacts() {
        return this.contacts != null && !(this.contacts instanceof SdkAutoConstructList);
    }

    public final List<Contact> contacts() {
        return this.contacts;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buyerDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buyerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplierDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplierIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.selector());
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalSharedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalInstanceEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.testEnvPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.einvoiceDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.einvoiceDeliveryPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOrderRetrievalEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContacts() ? this.contacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProcurementPortalPreferenceRequest)) {
            return false;
        }
        CreateProcurementPortalPreferenceRequest other = (CreateProcurementPortalPreferenceRequest)((Object)obj);
        return Objects.equals(this.procurementPortalNameAsString(), other.procurementPortalNameAsString()) && Objects.equals(this.buyerDomainAsString(), other.buyerDomainAsString()) && Objects.equals(this.buyerIdentifier(), other.buyerIdentifier()) && Objects.equals(this.supplierDomainAsString(), other.supplierDomainAsString()) && Objects.equals(this.supplierIdentifier(), other.supplierIdentifier()) && Objects.equals(this.selector(), other.selector()) && Objects.equals(this.procurementPortalSharedSecret(), other.procurementPortalSharedSecret()) && Objects.equals(this.procurementPortalInstanceEndpoint(), other.procurementPortalInstanceEndpoint()) && Objects.equals(this.testEnvPreference(), other.testEnvPreference()) && Objects.equals(this.einvoiceDeliveryEnabled(), other.einvoiceDeliveryEnabled()) && Objects.equals(this.einvoiceDeliveryPreference(), other.einvoiceDeliveryPreference()) && Objects.equals(this.purchaseOrderRetrievalEnabled(), other.purchaseOrderRetrievalEnabled()) && this.hasContacts() == other.hasContacts() && Objects.equals(this.contacts(), other.contacts()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProcurementPortalPreferenceRequest").add("ProcurementPortalName", (Object)this.procurementPortalNameAsString()).add("BuyerDomain", (Object)this.buyerDomainAsString()).add("BuyerIdentifier", (Object)this.buyerIdentifier()).add("SupplierDomain", (Object)this.supplierDomainAsString()).add("SupplierIdentifier", (Object)this.supplierIdentifier()).add("Selector", (Object)this.selector()).add("ProcurementPortalSharedSecret", (Object)(this.procurementPortalSharedSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("ProcurementPortalInstanceEndpoint", (Object)this.procurementPortalInstanceEndpoint()).add("TestEnvPreference", (Object)this.testEnvPreference()).add("EinvoiceDeliveryEnabled", (Object)this.einvoiceDeliveryEnabled()).add("EinvoiceDeliveryPreference", (Object)this.einvoiceDeliveryPreference()).add("PurchaseOrderRetrievalEnabled", (Object)this.purchaseOrderRetrievalEnabled()).add("Contacts", (Object)(this.contacts() == null ? null : "*** Sensitive Data Redacted ***")).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcurementPortalName": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalNameAsString()));
            }
            case "BuyerDomain": {
                return Optional.ofNullable(clazz.cast(this.buyerDomainAsString()));
            }
            case "BuyerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.buyerIdentifier()));
            }
            case "SupplierDomain": {
                return Optional.ofNullable(clazz.cast(this.supplierDomainAsString()));
            }
            case "SupplierIdentifier": {
                return Optional.ofNullable(clazz.cast(this.supplierIdentifier()));
            }
            case "Selector": {
                return Optional.ofNullable(clazz.cast(this.selector()));
            }
            case "ProcurementPortalSharedSecret": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalSharedSecret()));
            }
            case "ProcurementPortalInstanceEndpoint": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalInstanceEndpoint()));
            }
            case "TestEnvPreference": {
                return Optional.ofNullable(clazz.cast(this.testEnvPreference()));
            }
            case "EinvoiceDeliveryEnabled": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryEnabled()));
            }
            case "EinvoiceDeliveryPreference": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryPreference()));
            }
            case "PurchaseOrderRetrievalEnabled": {
                return Optional.ofNullable(clazz.cast(this.purchaseOrderRetrievalEnabled()));
            }
            case "Contacts": {
                return Optional.ofNullable(clazz.cast(this.contacts()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProcurementPortalName", PROCUREMENT_PORTAL_NAME_FIELD);
        map.put("BuyerDomain", BUYER_DOMAIN_FIELD);
        map.put("BuyerIdentifier", BUYER_IDENTIFIER_FIELD);
        map.put("SupplierDomain", SUPPLIER_DOMAIN_FIELD);
        map.put("SupplierIdentifier", SUPPLIER_IDENTIFIER_FIELD);
        map.put("Selector", SELECTOR_FIELD);
        map.put("ProcurementPortalSharedSecret", PROCUREMENT_PORTAL_SHARED_SECRET_FIELD);
        map.put("ProcurementPortalInstanceEndpoint", PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD);
        map.put("TestEnvPreference", TEST_ENV_PREFERENCE_FIELD);
        map.put("EinvoiceDeliveryEnabled", EINVOICE_DELIVERY_ENABLED_FIELD);
        map.put("EinvoiceDeliveryPreference", EINVOICE_DELIVERY_PREFERENCE_FIELD);
        map.put("PurchaseOrderRetrievalEnabled", PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD);
        map.put("Contacts", CONTACTS_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProcurementPortalPreferenceRequest, T> g) {
        return obj -> g.apply((CreateProcurementPortalPreferenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InvoicingRequest.BuilderImpl
    implements Builder {
        private String procurementPortalName;
        private String buyerDomain;
        private String buyerIdentifier;
        private String supplierDomain;
        private String supplierIdentifier;
        private ProcurementPortalPreferenceSelector selector;
        private String procurementPortalSharedSecret;
        private String procurementPortalInstanceEndpoint;
        private TestEnvPreferenceInput testEnvPreference;
        private Boolean einvoiceDeliveryEnabled;
        private EinvoiceDeliveryPreference einvoiceDeliveryPreference;
        private Boolean purchaseOrderRetrievalEnabled;
        private List<Contact> contacts = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProcurementPortalPreferenceRequest model) {
            super(model);
            this.procurementPortalName(model.procurementPortalName);
            this.buyerDomain(model.buyerDomain);
            this.buyerIdentifier(model.buyerIdentifier);
            this.supplierDomain(model.supplierDomain);
            this.supplierIdentifier(model.supplierIdentifier);
            this.selector(model.selector);
            this.procurementPortalSharedSecret(model.procurementPortalSharedSecret);
            this.procurementPortalInstanceEndpoint(model.procurementPortalInstanceEndpoint);
            this.testEnvPreference(model.testEnvPreference);
            this.einvoiceDeliveryEnabled(model.einvoiceDeliveryEnabled);
            this.einvoiceDeliveryPreference(model.einvoiceDeliveryPreference);
            this.purchaseOrderRetrievalEnabled(model.purchaseOrderRetrievalEnabled);
            this.contacts(model.contacts);
            this.resourceTags(model.resourceTags);
            this.clientToken(model.clientToken);
        }

        public final String getProcurementPortalName() {
            return this.procurementPortalName;
        }

        public final void setProcurementPortalName(String procurementPortalName) {
            this.procurementPortalName = procurementPortalName;
        }

        @Override
        public final Builder procurementPortalName(String procurementPortalName) {
            this.procurementPortalName = procurementPortalName;
            return this;
        }

        @Override
        public final Builder procurementPortalName(ProcurementPortalName procurementPortalName) {
            this.procurementPortalName(procurementPortalName == null ? null : procurementPortalName.toString());
            return this;
        }

        public final String getBuyerDomain() {
            return this.buyerDomain;
        }

        public final void setBuyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
        }

        @Override
        public final Builder buyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
            return this;
        }

        @Override
        public final Builder buyerDomain(BuyerDomain buyerDomain) {
            this.buyerDomain(buyerDomain == null ? null : buyerDomain.toString());
            return this;
        }

        public final String getBuyerIdentifier() {
            return this.buyerIdentifier;
        }

        public final void setBuyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
        }

        @Override
        public final Builder buyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
            return this;
        }

        public final String getSupplierDomain() {
            return this.supplierDomain;
        }

        public final void setSupplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
        }

        @Override
        public final Builder supplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
            return this;
        }

        @Override
        public final Builder supplierDomain(SupplierDomain supplierDomain) {
            this.supplierDomain(supplierDomain == null ? null : supplierDomain.toString());
            return this;
        }

        public final String getSupplierIdentifier() {
            return this.supplierIdentifier;
        }

        public final void setSupplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
        }

        @Override
        public final Builder supplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
            return this;
        }

        public final ProcurementPortalPreferenceSelector.Builder getSelector() {
            return this.selector != null ? this.selector.toBuilder() : null;
        }

        public final void setSelector(ProcurementPortalPreferenceSelector.BuilderImpl selector) {
            this.selector = selector != null ? selector.build() : null;
        }

        @Override
        public final Builder selector(ProcurementPortalPreferenceSelector selector) {
            this.selector = selector;
            return this;
        }

        public final String getProcurementPortalSharedSecret() {
            return this.procurementPortalSharedSecret;
        }

        public final void setProcurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
        }

        @Override
        public final Builder procurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
            return this;
        }

        public final String getProcurementPortalInstanceEndpoint() {
            return this.procurementPortalInstanceEndpoint;
        }

        public final void setProcurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
        }

        @Override
        public final Builder procurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
            return this;
        }

        public final TestEnvPreferenceInput.Builder getTestEnvPreference() {
            return this.testEnvPreference != null ? this.testEnvPreference.toBuilder() : null;
        }

        public final void setTestEnvPreference(TestEnvPreferenceInput.BuilderImpl testEnvPreference) {
            this.testEnvPreference = testEnvPreference != null ? testEnvPreference.build() : null;
        }

        @Override
        public final Builder testEnvPreference(TestEnvPreferenceInput testEnvPreference) {
            this.testEnvPreference = testEnvPreference;
            return this;
        }

        public final Boolean getEinvoiceDeliveryEnabled() {
            return this.einvoiceDeliveryEnabled;
        }

        public final void setEinvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
        }

        @Override
        public final Builder einvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
            return this;
        }

        public final EinvoiceDeliveryPreference.Builder getEinvoiceDeliveryPreference() {
            return this.einvoiceDeliveryPreference != null ? this.einvoiceDeliveryPreference.toBuilder() : null;
        }

        public final void setEinvoiceDeliveryPreference(EinvoiceDeliveryPreference.BuilderImpl einvoiceDeliveryPreference) {
            this.einvoiceDeliveryPreference = einvoiceDeliveryPreference != null ? einvoiceDeliveryPreference.build() : null;
        }

        @Override
        public final Builder einvoiceDeliveryPreference(EinvoiceDeliveryPreference einvoiceDeliveryPreference) {
            this.einvoiceDeliveryPreference = einvoiceDeliveryPreference;
            return this;
        }

        public final Boolean getPurchaseOrderRetrievalEnabled() {
            return this.purchaseOrderRetrievalEnabled;
        }

        public final void setPurchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
        }

        @Override
        public final Builder purchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
            return this;
        }

        public final List<Contact.Builder> getContacts() {
            List<Contact.Builder> result = ContactsCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContacts(Collection<Contact.BuilderImpl> contacts) {
            this.contacts = ContactsCopier.copyFromBuilder(contacts);
        }

        @Override
        public final Builder contacts(Collection<Contact> contacts) {
            this.contacts = ContactsCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Contact ... contacts) {
            this.contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<Contact.Builder> ... contacts) {
            this.contacts(Stream.of(contacts).map(c -> (Contact)((Contact.Builder)Contact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProcurementPortalPreferenceRequest build() {
            return new CreateProcurementPortalPreferenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InvoicingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProcurementPortalPreferenceRequest> {
        public Builder procurementPortalName(String var1);

        public Builder procurementPortalName(ProcurementPortalName var1);

        public Builder buyerDomain(String var1);

        public Builder buyerDomain(BuyerDomain var1);

        public Builder buyerIdentifier(String var1);

        public Builder supplierDomain(String var1);

        public Builder supplierDomain(SupplierDomain var1);

        public Builder supplierIdentifier(String var1);

        public Builder selector(ProcurementPortalPreferenceSelector var1);

        default public Builder selector(Consumer<ProcurementPortalPreferenceSelector.Builder> selector) {
            return this.selector((ProcurementPortalPreferenceSelector)((ProcurementPortalPreferenceSelector.Builder)ProcurementPortalPreferenceSelector.builder().applyMutation(selector)).build());
        }

        public Builder procurementPortalSharedSecret(String var1);

        public Builder procurementPortalInstanceEndpoint(String var1);

        public Builder testEnvPreference(TestEnvPreferenceInput var1);

        default public Builder testEnvPreference(Consumer<TestEnvPreferenceInput.Builder> testEnvPreference) {
            return this.testEnvPreference((TestEnvPreferenceInput)((TestEnvPreferenceInput.Builder)TestEnvPreferenceInput.builder().applyMutation(testEnvPreference)).build());
        }

        public Builder einvoiceDeliveryEnabled(Boolean var1);

        public Builder einvoiceDeliveryPreference(EinvoiceDeliveryPreference var1);

        default public Builder einvoiceDeliveryPreference(Consumer<EinvoiceDeliveryPreference.Builder> einvoiceDeliveryPreference) {
            return this.einvoiceDeliveryPreference((EinvoiceDeliveryPreference)((EinvoiceDeliveryPreference.Builder)EinvoiceDeliveryPreference.builder().applyMutation(einvoiceDeliveryPreference)).build());
        }

        public Builder purchaseOrderRetrievalEnabled(Boolean var1);

        public Builder contacts(Collection<Contact> var1);

        public Builder contacts(Contact ... var1);

        public Builder contacts(Consumer<Contact.Builder> ... var1);

        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

