/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.invoicing.InvoicingAsyncClient;
import software.amazon.awssdk.services.invoicing.internal.UserAgentUtils;
import software.amazon.awssdk.services.invoicing.model.InvoiceUnit;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsResponse;

public class ListInvoiceUnitsPublisher
implements SdkPublisher<ListInvoiceUnitsResponse> {
    private final InvoicingAsyncClient client;
    private final ListInvoiceUnitsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInvoiceUnitsPublisher(InvoicingAsyncClient client, ListInvoiceUnitsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInvoiceUnitsPublisher(InvoicingAsyncClient client, ListInvoiceUnitsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInvoiceUnitsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInvoiceUnitsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InvoiceUnit> invoiceUnits() {
        Function<ListInvoiceUnitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invoiceUnits() != null) {
                return response.invoiceUnits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInvoiceUnitsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInvoiceUnitsResponseFetcher
    implements AsyncPageFetcher<ListInvoiceUnitsResponse> {
        private ListInvoiceUnitsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvoiceUnitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInvoiceUnitsResponse> nextPage(ListInvoiceUnitsResponse previousPage) {
            if (previousPage == null) {
                return ListInvoiceUnitsPublisher.this.client.listInvoiceUnits(ListInvoiceUnitsPublisher.this.firstRequest);
            }
            return ListInvoiceUnitsPublisher.this.client.listInvoiceUnits((ListInvoiceUnitsRequest)((Object)ListInvoiceUnitsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

