/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.invoicing.model.DiscountsBreakdown;
import software.amazon.awssdk.services.invoicing.model.FeesBreakdown;
import software.amazon.awssdk.services.invoicing.model.TaxesBreakdown;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmountBreakdown
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmountBreakdown> {
    private static final SdkField<String> SUB_TOTAL_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubTotalAmount").getter(AmountBreakdown.getter(AmountBreakdown::subTotalAmount)).setter(AmountBreakdown.setter(Builder::subTotalAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubTotalAmount").build()}).build();
    private static final SdkField<DiscountsBreakdown> DISCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Discounts").getter(AmountBreakdown.getter(AmountBreakdown::discounts)).setter(AmountBreakdown.setter(Builder::discounts)).constructor(DiscountsBreakdown::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Discounts").build()}).build();
    private static final SdkField<TaxesBreakdown> TAXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Taxes").getter(AmountBreakdown.getter(AmountBreakdown::taxes)).setter(AmountBreakdown.setter(Builder::taxes)).constructor(TaxesBreakdown::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Taxes").build()}).build();
    private static final SdkField<FeesBreakdown> FEES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Fees").getter(AmountBreakdown.getter(AmountBreakdown::fees)).setter(AmountBreakdown.setter(Builder::fees)).constructor(FeesBreakdown::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fees").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUB_TOTAL_AMOUNT_FIELD, DISCOUNTS_FIELD, TAXES_FIELD, FEES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AmountBreakdown.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subTotalAmount;
    private final DiscountsBreakdown discounts;
    private final TaxesBreakdown taxes;
    private final FeesBreakdown fees;

    private AmountBreakdown(BuilderImpl builder) {
        this.subTotalAmount = builder.subTotalAmount;
        this.discounts = builder.discounts;
        this.taxes = builder.taxes;
        this.fees = builder.fees;
    }

    public final String subTotalAmount() {
        return this.subTotalAmount;
    }

    public final DiscountsBreakdown discounts() {
        return this.discounts;
    }

    public final TaxesBreakdown taxes() {
        return this.taxes;
    }

    public final FeesBreakdown fees() {
        return this.fees;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subTotalAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.discounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxes());
        hashCode = 31 * hashCode + Objects.hashCode(this.fees());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmountBreakdown)) {
            return false;
        }
        AmountBreakdown other = (AmountBreakdown)obj;
        return Objects.equals(this.subTotalAmount(), other.subTotalAmount()) && Objects.equals(this.discounts(), other.discounts()) && Objects.equals(this.taxes(), other.taxes()) && Objects.equals(this.fees(), other.fees());
    }

    public final String toString() {
        return ToString.builder((String)"AmountBreakdown").add("SubTotalAmount", (Object)this.subTotalAmount()).add("Discounts", (Object)this.discounts()).add("Taxes", (Object)this.taxes()).add("Fees", (Object)this.fees()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubTotalAmount": {
                return Optional.ofNullable(clazz.cast(this.subTotalAmount()));
            }
            case "Discounts": {
                return Optional.ofNullable(clazz.cast(this.discounts()));
            }
            case "Taxes": {
                return Optional.ofNullable(clazz.cast(this.taxes()));
            }
            case "Fees": {
                return Optional.ofNullable(clazz.cast(this.fees()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubTotalAmount", SUB_TOTAL_AMOUNT_FIELD);
        map.put("Discounts", DISCOUNTS_FIELD);
        map.put("Taxes", TAXES_FIELD);
        map.put("Fees", FEES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmountBreakdown, T> g) {
        return obj -> g.apply((AmountBreakdown)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subTotalAmount;
        private DiscountsBreakdown discounts;
        private TaxesBreakdown taxes;
        private FeesBreakdown fees;

        private BuilderImpl() {
        }

        private BuilderImpl(AmountBreakdown model) {
            this.subTotalAmount(model.subTotalAmount);
            this.discounts(model.discounts);
            this.taxes(model.taxes);
            this.fees(model.fees);
        }

        public final String getSubTotalAmount() {
            return this.subTotalAmount;
        }

        public final void setSubTotalAmount(String subTotalAmount) {
            this.subTotalAmount = subTotalAmount;
        }

        @Override
        public final Builder subTotalAmount(String subTotalAmount) {
            this.subTotalAmount = subTotalAmount;
            return this;
        }

        public final DiscountsBreakdown.Builder getDiscounts() {
            return this.discounts != null ? this.discounts.toBuilder() : null;
        }

        public final void setDiscounts(DiscountsBreakdown.BuilderImpl discounts) {
            this.discounts = discounts != null ? discounts.build() : null;
        }

        @Override
        public final Builder discounts(DiscountsBreakdown discounts) {
            this.discounts = discounts;
            return this;
        }

        public final TaxesBreakdown.Builder getTaxes() {
            return this.taxes != null ? this.taxes.toBuilder() : null;
        }

        public final void setTaxes(TaxesBreakdown.BuilderImpl taxes) {
            this.taxes = taxes != null ? taxes.build() : null;
        }

        @Override
        public final Builder taxes(TaxesBreakdown taxes) {
            this.taxes = taxes;
            return this;
        }

        public final FeesBreakdown.Builder getFees() {
            return this.fees != null ? this.fees.toBuilder() : null;
        }

        public final void setFees(FeesBreakdown.BuilderImpl fees) {
            this.fees = fees != null ? fees.build() : null;
        }

        @Override
        public final Builder fees(FeesBreakdown fees) {
            this.fees = fees;
            return this;
        }

        public AmountBreakdown build() {
            return new AmountBreakdown(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmountBreakdown> {
        public Builder subTotalAmount(String var1);

        public Builder discounts(DiscountsBreakdown var1);

        default public Builder discounts(Consumer<DiscountsBreakdown.Builder> discounts) {
            return this.discounts((DiscountsBreakdown)((DiscountsBreakdown.Builder)DiscountsBreakdown.builder().applyMutation(discounts)).build());
        }

        public Builder taxes(TaxesBreakdown var1);

        default public Builder taxes(Consumer<TaxesBreakdown.Builder> taxes) {
            return this.taxes((TaxesBreakdown)((TaxesBreakdown.Builder)TaxesBreakdown.builder().applyMutation(taxes)).build());
        }

        public Builder fees(FeesBreakdown var1);

        default public Builder fees(Consumer<FeesBreakdown.Builder> fees) {
            return this.fees((FeesBreakdown)((FeesBreakdown.Builder)FeesBreakdown.builder().applyMutation(fees)).build());
        }
    }
}

