/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.internetmonitor.model.LocalHealthEventsConfigStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocalHealthEventsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocalHealthEventsConfig> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LocalHealthEventsConfig.getter(LocalHealthEventsConfig::statusAsString)).setter(LocalHealthEventsConfig.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Double> HEALTH_SCORE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("HealthScoreThreshold").getter(LocalHealthEventsConfig.getter(LocalHealthEventsConfig::healthScoreThreshold)).setter(LocalHealthEventsConfig.setter(Builder::healthScoreThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthScoreThreshold").build()}).build();
    private static final SdkField<Double> MIN_TRAFFIC_IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinTrafficImpact").getter(LocalHealthEventsConfig.getter(LocalHealthEventsConfig::minTrafficImpact)).setter(LocalHealthEventsConfig.setter(Builder::minTrafficImpact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTrafficImpact").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, HEALTH_SCORE_THRESHOLD_FIELD, MIN_TRAFFIC_IMPACT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LocalHealthEventsConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Double healthScoreThreshold;
    private final Double minTrafficImpact;

    private LocalHealthEventsConfig(BuilderImpl builder) {
        this.status = builder.status;
        this.healthScoreThreshold = builder.healthScoreThreshold;
        this.minTrafficImpact = builder.minTrafficImpact;
    }

    public final LocalHealthEventsConfigStatus status() {
        return LocalHealthEventsConfigStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Double healthScoreThreshold() {
        return this.healthScoreThreshold;
    }

    public final Double minTrafficImpact() {
        return this.minTrafficImpact;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthScoreThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.minTrafficImpact());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalHealthEventsConfig)) {
            return false;
        }
        LocalHealthEventsConfig other = (LocalHealthEventsConfig)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.healthScoreThreshold(), other.healthScoreThreshold()) && Objects.equals(this.minTrafficImpact(), other.minTrafficImpact());
    }

    public final String toString() {
        return ToString.builder((String)"LocalHealthEventsConfig").add("Status", (Object)this.statusAsString()).add("HealthScoreThreshold", (Object)this.healthScoreThreshold()).add("MinTrafficImpact", (Object)this.minTrafficImpact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "HealthScoreThreshold": {
                return Optional.ofNullable(clazz.cast(this.healthScoreThreshold()));
            }
            case "MinTrafficImpact": {
                return Optional.ofNullable(clazz.cast(this.minTrafficImpact()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("HealthScoreThreshold", HEALTH_SCORE_THRESHOLD_FIELD);
        map.put("MinTrafficImpact", MIN_TRAFFIC_IMPACT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LocalHealthEventsConfig, T> g) {
        return obj -> g.apply((LocalHealthEventsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Double healthScoreThreshold;
        private Double minTrafficImpact;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalHealthEventsConfig model) {
            this.status(model.status);
            this.healthScoreThreshold(model.healthScoreThreshold);
            this.minTrafficImpact(model.minTrafficImpact);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LocalHealthEventsConfigStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Double getHealthScoreThreshold() {
            return this.healthScoreThreshold;
        }

        public final void setHealthScoreThreshold(Double healthScoreThreshold) {
            this.healthScoreThreshold = healthScoreThreshold;
        }

        @Override
        public final Builder healthScoreThreshold(Double healthScoreThreshold) {
            this.healthScoreThreshold = healthScoreThreshold;
            return this;
        }

        public final Double getMinTrafficImpact() {
            return this.minTrafficImpact;
        }

        public final void setMinTrafficImpact(Double minTrafficImpact) {
            this.minTrafficImpact = minTrafficImpact;
        }

        @Override
        public final Builder minTrafficImpact(Double minTrafficImpact) {
            this.minTrafficImpact = minTrafficImpact;
            return this;
        }

        public LocalHealthEventsConfig build() {
            return new LocalHealthEventsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocalHealthEventsConfig> {
        public Builder status(String var1);

        public Builder status(LocalHealthEventsConfigStatus var1);

        public Builder healthScoreThreshold(Double var1);

        public Builder minTrafficImpact(Double var1);
    }
}

