/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.internetmonitor.model.HealthEventImpactType;
import software.amazon.awssdk.services.internetmonitor.model.HealthEventStatus;
import software.amazon.awssdk.services.internetmonitor.model.ImpactedLocation;
import software.amazon.awssdk.services.internetmonitor.model.ImpactedLocationsListCopier;
import software.amazon.awssdk.services.internetmonitor.model.InternetMonitorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHealthEventResponse
extends InternetMonitorResponse
implements ToCopyableBuilder<Builder, GetHealthEventResponse> {
    private static final SdkField<String> EVENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventArn").getter(GetHealthEventResponse.getter(GetHealthEventResponse::eventArn)).setter(GetHealthEventResponse.setter(Builder::eventArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventArn").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(GetHealthEventResponse.getter(GetHealthEventResponse::eventId)).setter(GetHealthEventResponse.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(GetHealthEventResponse.getter(GetHealthEventResponse::startedAt)).setter(GetHealthEventResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndedAt").getter(GetHealthEventResponse.getter(GetHealthEventResponse::endedAt)).setter(GetHealthEventResponse.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetHealthEventResponse.getter(GetHealthEventResponse::createdAt)).setter(GetHealthEventResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GetHealthEventResponse.getter(GetHealthEventResponse::lastUpdatedAt)).setter(GetHealthEventResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<ImpactedLocation>> IMPACTED_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImpactedLocations").getter(GetHealthEventResponse.getter(GetHealthEventResponse::impactedLocations)).setter(GetHealthEventResponse.setter(Builder::impactedLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpactedLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImpactedLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetHealthEventResponse.getter(GetHealthEventResponse::statusAsString)).setter(GetHealthEventResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Double> PERCENT_OF_TOTAL_TRAFFIC_IMPACTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PercentOfTotalTrafficImpacted").getter(GetHealthEventResponse.getter(GetHealthEventResponse::percentOfTotalTrafficImpacted)).setter(GetHealthEventResponse.setter(Builder::percentOfTotalTrafficImpacted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentOfTotalTrafficImpacted").build()}).build();
    private static final SdkField<String> IMPACT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImpactType").getter(GetHealthEventResponse.getter(GetHealthEventResponse::impactTypeAsString)).setter(GetHealthEventResponse.setter(Builder::impactType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpactType").build()}).build();
    private static final SdkField<Double> HEALTH_SCORE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("HealthScoreThreshold").getter(GetHealthEventResponse.getter(GetHealthEventResponse::healthScoreThreshold)).setter(GetHealthEventResponse.setter(Builder::healthScoreThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthScoreThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARN_FIELD, EVENT_ID_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, IMPACTED_LOCATIONS_FIELD, STATUS_FIELD, PERCENT_OF_TOTAL_TRAFFIC_IMPACTED_FIELD, IMPACT_TYPE_FIELD, HEALTH_SCORE_THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetHealthEventResponse.memberNameToFieldInitializer();
    private final String eventArn;
    private final String eventId;
    private final Instant startedAt;
    private final Instant endedAt;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final List<ImpactedLocation> impactedLocations;
    private final String status;
    private final Double percentOfTotalTrafficImpacted;
    private final String impactType;
    private final Double healthScoreThreshold;

    private GetHealthEventResponse(BuilderImpl builder) {
        super(builder);
        this.eventArn = builder.eventArn;
        this.eventId = builder.eventId;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.impactedLocations = builder.impactedLocations;
        this.status = builder.status;
        this.percentOfTotalTrafficImpacted = builder.percentOfTotalTrafficImpacted;
        this.impactType = builder.impactType;
        this.healthScoreThreshold = builder.healthScoreThreshold;
    }

    public final String eventArn() {
        return this.eventArn;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasImpactedLocations() {
        return this.impactedLocations != null && !(this.impactedLocations instanceof SdkAutoConstructList);
    }

    public final List<ImpactedLocation> impactedLocations() {
        return this.impactedLocations;
    }

    public final HealthEventStatus status() {
        return HealthEventStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Double percentOfTotalTrafficImpacted() {
        return this.percentOfTotalTrafficImpacted;
    }

    public final HealthEventImpactType impactType() {
        return HealthEventImpactType.fromValue(this.impactType);
    }

    public final String impactTypeAsString() {
        return this.impactType;
    }

    public final Double healthScoreThreshold() {
        return this.healthScoreThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedLocations() ? this.impactedLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentOfTotalTrafficImpacted());
        hashCode = 31 * hashCode + Objects.hashCode(this.impactTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthScoreThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthEventResponse)) {
            return false;
        }
        GetHealthEventResponse other = (GetHealthEventResponse)((Object)obj);
        return Objects.equals(this.eventArn(), other.eventArn()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasImpactedLocations() == other.hasImpactedLocations() && Objects.equals(this.impactedLocations(), other.impactedLocations()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.percentOfTotalTrafficImpacted(), other.percentOfTotalTrafficImpacted()) && Objects.equals(this.impactTypeAsString(), other.impactTypeAsString()) && Objects.equals(this.healthScoreThreshold(), other.healthScoreThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"GetHealthEventResponse").add("EventArn", (Object)this.eventArn()).add("EventId", (Object)this.eventId()).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("ImpactedLocations", this.hasImpactedLocations() ? this.impactedLocations() : null).add("Status", (Object)this.statusAsString()).add("PercentOfTotalTrafficImpacted", (Object)this.percentOfTotalTrafficImpacted()).add("ImpactType", (Object)this.impactTypeAsString()).add("HealthScoreThreshold", (Object)this.healthScoreThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventArn": {
                return Optional.ofNullable(clazz.cast(this.eventArn()));
            }
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "EndedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "ImpactedLocations": {
                return Optional.ofNullable(clazz.cast(this.impactedLocations()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "PercentOfTotalTrafficImpacted": {
                return Optional.ofNullable(clazz.cast(this.percentOfTotalTrafficImpacted()));
            }
            case "ImpactType": {
                return Optional.ofNullable(clazz.cast(this.impactTypeAsString()));
            }
            case "HealthScoreThreshold": {
                return Optional.ofNullable(clazz.cast(this.healthScoreThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventArn", EVENT_ARN_FIELD);
        map.put("EventId", EVENT_ID_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("EndedAt", ENDED_AT_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("ImpactedLocations", IMPACTED_LOCATIONS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("PercentOfTotalTrafficImpacted", PERCENT_OF_TOTAL_TRAFFIC_IMPACTED_FIELD);
        map.put("ImpactType", IMPACT_TYPE_FIELD);
        map.put("HealthScoreThreshold", HEALTH_SCORE_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetHealthEventResponse, T> g) {
        return obj -> g.apply((GetHealthEventResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InternetMonitorResponse.BuilderImpl
    implements Builder {
        private String eventArn;
        private String eventId;
        private Instant startedAt;
        private Instant endedAt;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private List<ImpactedLocation> impactedLocations = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Double percentOfTotalTrafficImpacted;
        private String impactType;
        private Double healthScoreThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthEventResponse model) {
            super(model);
            this.eventArn(model.eventArn);
            this.eventId(model.eventId);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.impactedLocations(model.impactedLocations);
            this.status(model.status);
            this.percentOfTotalTrafficImpacted(model.percentOfTotalTrafficImpacted);
            this.impactType(model.impactType);
            this.healthScoreThreshold(model.healthScoreThreshold);
        }

        public final String getEventArn() {
            return this.eventArn;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        @Override
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final List<ImpactedLocation.Builder> getImpactedLocations() {
            List<ImpactedLocation.Builder> result = ImpactedLocationsListCopier.copyToBuilder(this.impactedLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImpactedLocations(Collection<ImpactedLocation.BuilderImpl> impactedLocations) {
            this.impactedLocations = ImpactedLocationsListCopier.copyFromBuilder(impactedLocations);
        }

        @Override
        public final Builder impactedLocations(Collection<ImpactedLocation> impactedLocations) {
            this.impactedLocations = ImpactedLocationsListCopier.copy(impactedLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedLocations(ImpactedLocation ... impactedLocations) {
            this.impactedLocations(Arrays.asList(impactedLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedLocations(Consumer<ImpactedLocation.Builder> ... impactedLocations) {
            this.impactedLocations(Stream.of(impactedLocations).map(c -> (ImpactedLocation)((ImpactedLocation.Builder)ImpactedLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HealthEventStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Double getPercentOfTotalTrafficImpacted() {
            return this.percentOfTotalTrafficImpacted;
        }

        public final void setPercentOfTotalTrafficImpacted(Double percentOfTotalTrafficImpacted) {
            this.percentOfTotalTrafficImpacted = percentOfTotalTrafficImpacted;
        }

        @Override
        public final Builder percentOfTotalTrafficImpacted(Double percentOfTotalTrafficImpacted) {
            this.percentOfTotalTrafficImpacted = percentOfTotalTrafficImpacted;
            return this;
        }

        public final String getImpactType() {
            return this.impactType;
        }

        public final void setImpactType(String impactType) {
            this.impactType = impactType;
        }

        @Override
        public final Builder impactType(String impactType) {
            this.impactType = impactType;
            return this;
        }

        @Override
        public final Builder impactType(HealthEventImpactType impactType) {
            this.impactType(impactType == null ? null : impactType.toString());
            return this;
        }

        public final Double getHealthScoreThreshold() {
            return this.healthScoreThreshold;
        }

        public final void setHealthScoreThreshold(Double healthScoreThreshold) {
            this.healthScoreThreshold = healthScoreThreshold;
        }

        @Override
        public final Builder healthScoreThreshold(Double healthScoreThreshold) {
            this.healthScoreThreshold = healthScoreThreshold;
            return this;
        }

        @Override
        public GetHealthEventResponse build() {
            return new GetHealthEventResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InternetMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetHealthEventResponse> {
        public Builder eventArn(String var1);

        public Builder eventId(String var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder impactedLocations(Collection<ImpactedLocation> var1);

        public Builder impactedLocations(ImpactedLocation ... var1);

        public Builder impactedLocations(Consumer<ImpactedLocation.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(HealthEventStatus var1);

        public Builder percentOfTotalTrafficImpacted(Double var1);

        public Builder impactType(String var1);

        public Builder impactType(HealthEventImpactType var1);

        public Builder healthScoreThreshold(Double var1);
    }
}

