/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.internetmonitor.model.AvailabilityMeasurement;
import software.amazon.awssdk.services.internetmonitor.model.PerformanceMeasurement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InternetHealth
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InternetHealth> {
    private static final SdkField<AvailabilityMeasurement> AVAILABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Availability").getter(InternetHealth.getter(InternetHealth::availability)).setter(InternetHealth.setter(Builder::availability)).constructor(AvailabilityMeasurement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Availability").build()}).build();
    private static final SdkField<PerformanceMeasurement> PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Performance").getter(InternetHealth.getter(InternetHealth::performance)).setter(InternetHealth.setter(Builder::performance)).constructor(PerformanceMeasurement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Performance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_FIELD, PERFORMANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InternetHealth.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AvailabilityMeasurement availability;
    private final PerformanceMeasurement performance;

    private InternetHealth(BuilderImpl builder) {
        this.availability = builder.availability;
        this.performance = builder.performance;
    }

    public final AvailabilityMeasurement availability() {
        return this.availability;
    }

    public final PerformanceMeasurement performance() {
        return this.performance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availability());
        hashCode = 31 * hashCode + Objects.hashCode(this.performance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternetHealth)) {
            return false;
        }
        InternetHealth other = (InternetHealth)obj;
        return Objects.equals(this.availability(), other.availability()) && Objects.equals(this.performance(), other.performance());
    }

    public final String toString() {
        return ToString.builder((String)"InternetHealth").add("Availability", (Object)this.availability()).add("Performance", (Object)this.performance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Availability": {
                return Optional.ofNullable(clazz.cast(this.availability()));
            }
            case "Performance": {
                return Optional.ofNullable(clazz.cast(this.performance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Availability", AVAILABILITY_FIELD);
        map.put("Performance", PERFORMANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InternetHealth, T> g) {
        return obj -> g.apply((InternetHealth)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AvailabilityMeasurement availability;
        private PerformanceMeasurement performance;

        private BuilderImpl() {
        }

        private BuilderImpl(InternetHealth model) {
            this.availability(model.availability);
            this.performance(model.performance);
        }

        public final AvailabilityMeasurement.Builder getAvailability() {
            return this.availability != null ? this.availability.toBuilder() : null;
        }

        public final void setAvailability(AvailabilityMeasurement.BuilderImpl availability) {
            this.availability = availability != null ? availability.build() : null;
        }

        @Override
        public final Builder availability(AvailabilityMeasurement availability) {
            this.availability = availability;
            return this;
        }

        public final PerformanceMeasurement.Builder getPerformance() {
            return this.performance != null ? this.performance.toBuilder() : null;
        }

        public final void setPerformance(PerformanceMeasurement.BuilderImpl performance) {
            this.performance = performance != null ? performance.build() : null;
        }

        @Override
        public final Builder performance(PerformanceMeasurement performance) {
            this.performance = performance;
            return this;
        }

        public InternetHealth build() {
            return new InternetHealth(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InternetHealth> {
        public Builder availability(AvailabilityMeasurement var1);

        default public Builder availability(Consumer<AvailabilityMeasurement.Builder> availability) {
            return this.availability((AvailabilityMeasurement)((AvailabilityMeasurement.Builder)AvailabilityMeasurement.builder().applyMutation(availability)).build());
        }

        public Builder performance(PerformanceMeasurement var1);

        default public Builder performance(Consumer<PerformanceMeasurement.Builder> performance) {
            return this.performance((PerformanceMeasurement)((PerformanceMeasurement.Builder)PerformanceMeasurement.builder().applyMutation(performance)).build());
        }
    }
}

