/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.CisScanResultDetails;
import software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsRequest;
import software.amazon.awssdk.services.inspector2.model.GetCisScanResultDetailsResponse;

public class GetCisScanResultDetailsIterable
implements SdkIterable<GetCisScanResultDetailsResponse> {
    private final Inspector2Client client;
    private final GetCisScanResultDetailsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCisScanResultDetailsIterable(Inspector2Client client, GetCisScanResultDetailsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCisScanResultDetailsResponseFetcher();
    }

    public Iterator<GetCisScanResultDetailsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CisScanResultDetails> scanResultDetails() {
        Function<GetCisScanResultDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scanResultDetails() != null) {
                return response.scanResultDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetCisScanResultDetailsResponseFetcher
    implements SyncPageFetcher<GetCisScanResultDetailsResponse> {
        private GetCisScanResultDetailsResponseFetcher() {
        }

        public boolean hasNextPage(GetCisScanResultDetailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCisScanResultDetailsResponse nextPage(GetCisScanResultDetailsResponse previousPage) {
            if (previousPage == null) {
                return GetCisScanResultDetailsIterable.this.client.getCisScanResultDetails(GetCisScanResultDetailsIterable.this.firstRequest);
            }
            return GetCisScanResultDetailsIterable.this.client.getCisScanResultDetails((GetCisScanResultDetailsRequest)((Object)GetCisScanResultDetailsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

