/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.Usage;
import software.amazon.awssdk.services.inspector2.model.UsageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageTotal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageTotal> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(UsageTotal.getter(UsageTotal::accountId)).setter(UsageTotal.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<List<Usage>> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("usage").getter(UsageTotal.getter(UsageTotal::usage)).setter(UsageTotal.setter(Builder::usage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Usage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, USAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UsageTotal.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final List<Usage> usage;

    private UsageTotal(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.usage = builder.usage;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final boolean hasUsage() {
        return this.usage != null && !(this.usage instanceof SdkAutoConstructList);
    }

    public final List<Usage> usage() {
        return this.usage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsage() ? this.usage() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageTotal)) {
            return false;
        }
        UsageTotal other = (UsageTotal)obj;
        return Objects.equals(this.accountId(), other.accountId()) && this.hasUsage() == other.hasUsage() && Objects.equals(this.usage(), other.usage());
    }

    public final String toString() {
        return ToString.builder((String)"UsageTotal").add("AccountId", (Object)this.accountId()).add("Usage", this.hasUsage() ? this.usage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "usage": {
                return Optional.ofNullable(clazz.cast(this.usage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("usage", USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageTotal, T> g) {
        return obj -> g.apply((UsageTotal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private List<Usage> usage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageTotal model) {
            this.accountId(model.accountId);
            this.usage(model.usage);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final List<Usage.Builder> getUsage() {
            List<Usage.Builder> result = UsageListCopier.copyToBuilder(this.usage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsage(Collection<Usage.BuilderImpl> usage) {
            this.usage = UsageListCopier.copyFromBuilder(usage);
        }

        @Override
        public final Builder usage(Collection<Usage> usage) {
            this.usage = UsageListCopier.copy(usage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(Usage ... usage) {
            this.usage(Arrays.asList(usage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(Consumer<Usage.Builder> ... usage) {
            this.usage(Stream.of(usage).map(c -> (Usage)((Usage.Builder)Usage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UsageTotal build() {
            return new UsageTotal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageTotal> {
        public Builder accountId(String var1);

        public Builder usage(Collection<Usage> var1);

        public Builder usage(Usage ... var1);

        public Builder usage(Consumer<Usage.Builder> ... var1);
    }
}

