/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceMapComparison {
    EQUALS("EQUALS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceMapComparison> VALUE_MAP;
    private final String value;

    private ResourceMapComparison(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceMapComparison fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceMapComparison> knownValues() {
        EnumSet<ResourceMapComparison> knownValues = EnumSet.allOf(ResourceMapComparison.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceMapComparison.class, ResourceMapComparison::toString);
    }
}

