/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.ProjectContinuousIntegrationScanConfiguration;
import software.amazon.awssdk.services.inspector2.model.ProjectContinuousIntegrationScanConfigurationListCopier;
import software.amazon.awssdk.services.inspector2.model.ProjectPeriodicScanConfiguration;
import software.amazon.awssdk.services.inspector2.model.ProjectPeriodicScanConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectCodeSecurityScanConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectCodeSecurityScanConfiguration> {
    private static final SdkField<List<ProjectPeriodicScanConfiguration>> PERIODIC_SCAN_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("periodicScanConfigurations").getter(ProjectCodeSecurityScanConfiguration.getter(ProjectCodeSecurityScanConfiguration::periodicScanConfigurations)).setter(ProjectCodeSecurityScanConfiguration.setter(Builder::periodicScanConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodicScanConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectPeriodicScanConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProjectContinuousIntegrationScanConfiguration>> CONTINUOUS_INTEGRATION_SCAN_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("continuousIntegrationScanConfigurations").getter(ProjectCodeSecurityScanConfiguration.getter(ProjectCodeSecurityScanConfiguration::continuousIntegrationScanConfigurations)).setter(ProjectCodeSecurityScanConfiguration.setter(Builder::continuousIntegrationScanConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuousIntegrationScanConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectContinuousIntegrationScanConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIODIC_SCAN_CONFIGURATIONS_FIELD, CONTINUOUS_INTEGRATION_SCAN_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProjectCodeSecurityScanConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ProjectPeriodicScanConfiguration> periodicScanConfigurations;
    private final List<ProjectContinuousIntegrationScanConfiguration> continuousIntegrationScanConfigurations;

    private ProjectCodeSecurityScanConfiguration(BuilderImpl builder) {
        this.periodicScanConfigurations = builder.periodicScanConfigurations;
        this.continuousIntegrationScanConfigurations = builder.continuousIntegrationScanConfigurations;
    }

    public final boolean hasPeriodicScanConfigurations() {
        return this.periodicScanConfigurations != null && !(this.periodicScanConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ProjectPeriodicScanConfiguration> periodicScanConfigurations() {
        return this.periodicScanConfigurations;
    }

    public final boolean hasContinuousIntegrationScanConfigurations() {
        return this.continuousIntegrationScanConfigurations != null && !(this.continuousIntegrationScanConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ProjectContinuousIntegrationScanConfiguration> continuousIntegrationScanConfigurations() {
        return this.continuousIntegrationScanConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeriodicScanConfigurations() ? this.periodicScanConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContinuousIntegrationScanConfigurations() ? this.continuousIntegrationScanConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectCodeSecurityScanConfiguration)) {
            return false;
        }
        ProjectCodeSecurityScanConfiguration other = (ProjectCodeSecurityScanConfiguration)obj;
        return this.hasPeriodicScanConfigurations() == other.hasPeriodicScanConfigurations() && Objects.equals(this.periodicScanConfigurations(), other.periodicScanConfigurations()) && this.hasContinuousIntegrationScanConfigurations() == other.hasContinuousIntegrationScanConfigurations() && Objects.equals(this.continuousIntegrationScanConfigurations(), other.continuousIntegrationScanConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectCodeSecurityScanConfiguration").add("PeriodicScanConfigurations", this.hasPeriodicScanConfigurations() ? this.periodicScanConfigurations() : null).add("ContinuousIntegrationScanConfigurations", this.hasContinuousIntegrationScanConfigurations() ? this.continuousIntegrationScanConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "periodicScanConfigurations": {
                return Optional.ofNullable(clazz.cast(this.periodicScanConfigurations()));
            }
            case "continuousIntegrationScanConfigurations": {
                return Optional.ofNullable(clazz.cast(this.continuousIntegrationScanConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("periodicScanConfigurations", PERIODIC_SCAN_CONFIGURATIONS_FIELD);
        map.put("continuousIntegrationScanConfigurations", CONTINUOUS_INTEGRATION_SCAN_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectCodeSecurityScanConfiguration, T> g) {
        return obj -> g.apply((ProjectCodeSecurityScanConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ProjectPeriodicScanConfiguration> periodicScanConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<ProjectContinuousIntegrationScanConfiguration> continuousIntegrationScanConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectCodeSecurityScanConfiguration model) {
            this.periodicScanConfigurations(model.periodicScanConfigurations);
            this.continuousIntegrationScanConfigurations(model.continuousIntegrationScanConfigurations);
        }

        public final List<ProjectPeriodicScanConfiguration.Builder> getPeriodicScanConfigurations() {
            List<ProjectPeriodicScanConfiguration.Builder> result = ProjectPeriodicScanConfigurationListCopier.copyToBuilder(this.periodicScanConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPeriodicScanConfigurations(Collection<ProjectPeriodicScanConfiguration.BuilderImpl> periodicScanConfigurations) {
            this.periodicScanConfigurations = ProjectPeriodicScanConfigurationListCopier.copyFromBuilder(periodicScanConfigurations);
        }

        @Override
        public final Builder periodicScanConfigurations(Collection<ProjectPeriodicScanConfiguration> periodicScanConfigurations) {
            this.periodicScanConfigurations = ProjectPeriodicScanConfigurationListCopier.copy(periodicScanConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodicScanConfigurations(ProjectPeriodicScanConfiguration ... periodicScanConfigurations) {
            this.periodicScanConfigurations(Arrays.asList(periodicScanConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodicScanConfigurations(Consumer<ProjectPeriodicScanConfiguration.Builder> ... periodicScanConfigurations) {
            this.periodicScanConfigurations(Stream.of(periodicScanConfigurations).map(c -> (ProjectPeriodicScanConfiguration)((ProjectPeriodicScanConfiguration.Builder)ProjectPeriodicScanConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProjectContinuousIntegrationScanConfiguration.Builder> getContinuousIntegrationScanConfigurations() {
            List<ProjectContinuousIntegrationScanConfiguration.Builder> result = ProjectContinuousIntegrationScanConfigurationListCopier.copyToBuilder(this.continuousIntegrationScanConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContinuousIntegrationScanConfigurations(Collection<ProjectContinuousIntegrationScanConfiguration.BuilderImpl> continuousIntegrationScanConfigurations) {
            this.continuousIntegrationScanConfigurations = ProjectContinuousIntegrationScanConfigurationListCopier.copyFromBuilder(continuousIntegrationScanConfigurations);
        }

        @Override
        public final Builder continuousIntegrationScanConfigurations(Collection<ProjectContinuousIntegrationScanConfiguration> continuousIntegrationScanConfigurations) {
            this.continuousIntegrationScanConfigurations = ProjectContinuousIntegrationScanConfigurationListCopier.copy(continuousIntegrationScanConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousIntegrationScanConfigurations(ProjectContinuousIntegrationScanConfiguration ... continuousIntegrationScanConfigurations) {
            this.continuousIntegrationScanConfigurations(Arrays.asList(continuousIntegrationScanConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousIntegrationScanConfigurations(Consumer<ProjectContinuousIntegrationScanConfiguration.Builder> ... continuousIntegrationScanConfigurations) {
            this.continuousIntegrationScanConfigurations(Stream.of(continuousIntegrationScanConfigurations).map(c -> (ProjectContinuousIntegrationScanConfiguration)((ProjectContinuousIntegrationScanConfiguration.Builder)ProjectContinuousIntegrationScanConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProjectCodeSecurityScanConfiguration build() {
            return new ProjectCodeSecurityScanConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectCodeSecurityScanConfiguration> {
        public Builder periodicScanConfigurations(Collection<ProjectPeriodicScanConfiguration> var1);

        public Builder periodicScanConfigurations(ProjectPeriodicScanConfiguration ... var1);

        public Builder periodicScanConfigurations(Consumer<ProjectPeriodicScanConfiguration.Builder> ... var1);

        public Builder continuousIntegrationScanConfigurations(Collection<ProjectContinuousIntegrationScanConfiguration> var1);

        public Builder continuousIntegrationScanConfigurations(ProjectContinuousIntegrationScanConfiguration ... var1);

        public Builder continuousIntegrationScanConfigurations(Consumer<ProjectContinuousIntegrationScanConfiguration.Builder> ... var1);
    }
}

