/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.ContinuousIntegrationScanEvent;
import software.amazon.awssdk.services.inspector2.model.ContinuousIntegrationScanSupportedEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContinuousIntegrationScanConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContinuousIntegrationScanConfiguration> {
    private static final SdkField<List<String>> SUPPORTED_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedEvents").getter(ContinuousIntegrationScanConfiguration.getter(ContinuousIntegrationScanConfiguration::supportedEventsAsStrings)).setter(ContinuousIntegrationScanConfiguration.setter(Builder::supportedEventsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContinuousIntegrationScanConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> supportedEvents;

    private ContinuousIntegrationScanConfiguration(BuilderImpl builder) {
        this.supportedEvents = builder.supportedEvents;
    }

    public final List<ContinuousIntegrationScanEvent> supportedEvents() {
        return ContinuousIntegrationScanSupportedEventsCopier.copyStringToEnum(this.supportedEvents);
    }

    public final boolean hasSupportedEvents() {
        return this.supportedEvents != null && !(this.supportedEvents instanceof SdkAutoConstructList);
    }

    public final List<String> supportedEventsAsStrings() {
        return this.supportedEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedEvents() ? this.supportedEventsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousIntegrationScanConfiguration)) {
            return false;
        }
        ContinuousIntegrationScanConfiguration other = (ContinuousIntegrationScanConfiguration)obj;
        return this.hasSupportedEvents() == other.hasSupportedEvents() && Objects.equals(this.supportedEventsAsStrings(), other.supportedEventsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ContinuousIntegrationScanConfiguration").add("SupportedEvents", this.hasSupportedEvents() ? this.supportedEventsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "supportedEvents": {
                return Optional.ofNullable(clazz.cast(this.supportedEventsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("supportedEvents", SUPPORTED_EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContinuousIntegrationScanConfiguration, T> g) {
        return obj -> g.apply((ContinuousIntegrationScanConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> supportedEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousIntegrationScanConfiguration model) {
            this.supportedEventsWithStrings(model.supportedEvents);
        }

        public final Collection<String> getSupportedEvents() {
            if (this.supportedEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedEvents;
        }

        public final void setSupportedEvents(Collection<String> supportedEvents) {
            this.supportedEvents = ContinuousIntegrationScanSupportedEventsCopier.copy(supportedEvents);
        }

        @Override
        public final Builder supportedEventsWithStrings(Collection<String> supportedEvents) {
            this.supportedEvents = ContinuousIntegrationScanSupportedEventsCopier.copy(supportedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEventsWithStrings(String ... supportedEvents) {
            this.supportedEventsWithStrings(Arrays.asList(supportedEvents));
            return this;
        }

        @Override
        public final Builder supportedEvents(Collection<ContinuousIntegrationScanEvent> supportedEvents) {
            this.supportedEvents = ContinuousIntegrationScanSupportedEventsCopier.copyEnumToString(supportedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEvents(ContinuousIntegrationScanEvent ... supportedEvents) {
            this.supportedEvents(Arrays.asList(supportedEvents));
            return this;
        }

        public ContinuousIntegrationScanConfiguration build() {
            return new ContinuousIntegrationScanConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContinuousIntegrationScanConfiguration> {
        public Builder supportedEventsWithStrings(Collection<String> var1);

        public Builder supportedEventsWithStrings(String ... var1);

        public Builder supportedEvents(Collection<ContinuousIntegrationScanEvent> var1);

        public Builder supportedEvents(ContinuousIntegrationScanEvent ... var1);
    }
}

