/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CodeRepositoryProviderType {
    GITHUB("GITHUB"),
    GITLAB_SELF_MANAGED("GITLAB_SELF_MANAGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CodeRepositoryProviderType> VALUE_MAP;
    private final String value;

    private CodeRepositoryProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CodeRepositoryProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CodeRepositoryProviderType> knownValues() {
        EnumSet<CodeRepositoryProviderType> knownValues = EnumSet.allOf(CodeRepositoryProviderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CodeRepositoryProviderType.class, CodeRepositoryProviderType::toString);
    }
}

