/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.CisScanConfiguration;
import software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse;

public class ListCisScanConfigurationsIterable
implements SdkIterable<ListCisScanConfigurationsResponse> {
    private final Inspector2Client client;
    private final ListCisScanConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCisScanConfigurationsIterable(Inspector2Client client, ListCisScanConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCisScanConfigurationsResponseFetcher();
    }

    public Iterator<ListCisScanConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CisScanConfiguration> scanConfigurations() {
        Function<ListCisScanConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scanConfigurations() != null) {
                return response.scanConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCisScanConfigurationsResponseFetcher
    implements SyncPageFetcher<ListCisScanConfigurationsResponse> {
        private ListCisScanConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCisScanConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCisScanConfigurationsResponse nextPage(ListCisScanConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListCisScanConfigurationsIterable.this.client.listCisScanConfigurations(ListCisScanConfigurationsIterable.this.firstRequest);
            }
            return ListCisScanConfigurationsIterable.this.client.listCisScanConfigurations((ListCisScanConfigurationsRequest)((Object)ListCisScanConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

