/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.SeverityCounts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryAggregationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryAggregationResponse> {
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repository").getter(RepositoryAggregationResponse.getter(RepositoryAggregationResponse::repository)).setter(RepositoryAggregationResponse.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(RepositoryAggregationResponse.getter(RepositoryAggregationResponse::accountId)).setter(RepositoryAggregationResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("severityCounts").getter(RepositoryAggregationResponse.getter(RepositoryAggregationResponse::severityCounts)).setter(RepositoryAggregationResponse.setter(Builder::severityCounts)).constructor(SeverityCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()}).build();
    private static final SdkField<Long> AFFECTED_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("affectedImages").getter(RepositoryAggregationResponse.getter(RepositoryAggregationResponse::affectedImages)).setter(RepositoryAggregationResponse.setter(Builder::affectedImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("affectedImages").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_FIELD, ACCOUNT_ID_FIELD, SEVERITY_COUNTS_FIELD, AFFECTED_IMAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RepositoryAggregationResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String repository;
    private final String accountId;
    private final SeverityCounts severityCounts;
    private final Long affectedImages;

    private RepositoryAggregationResponse(BuilderImpl builder) {
        this.repository = builder.repository;
        this.accountId = builder.accountId;
        this.severityCounts = builder.severityCounts;
        this.affectedImages = builder.affectedImages;
    }

    public final String repository() {
        return this.repository;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final SeverityCounts severityCounts() {
        return this.severityCounts;
    }

    public final Long affectedImages() {
        return this.affectedImages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.affectedImages());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryAggregationResponse)) {
            return false;
        }
        RepositoryAggregationResponse other = (RepositoryAggregationResponse)obj;
        return Objects.equals(this.repository(), other.repository()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.severityCounts(), other.severityCounts()) && Objects.equals(this.affectedImages(), other.affectedImages());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryAggregationResponse").add("Repository", (Object)this.repository()).add("AccountId", (Object)this.accountId()).add("SeverityCounts", (Object)this.severityCounts()).add("AffectedImages", (Object)this.affectedImages()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "severityCounts": {
                return Optional.ofNullable(clazz.cast(this.severityCounts()));
            }
            case "affectedImages": {
                return Optional.ofNullable(clazz.cast(this.affectedImages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("repository", REPOSITORY_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        map.put("affectedImages", AFFECTED_IMAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepositoryAggregationResponse, T> g) {
        return obj -> g.apply((RepositoryAggregationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repository;
        private String accountId;
        private SeverityCounts severityCounts;
        private Long affectedImages;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryAggregationResponse model) {
            this.repository(model.repository);
            this.accountId(model.accountId);
            this.severityCounts(model.severityCounts);
            this.affectedImages(model.affectedImages);
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return this.severityCounts != null ? this.severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public final Long getAffectedImages() {
            return this.affectedImages;
        }

        public final void setAffectedImages(Long affectedImages) {
            this.affectedImages = affectedImages;
        }

        @Override
        public final Builder affectedImages(Long affectedImages) {
            this.affectedImages = affectedImages;
            return this;
        }

        public RepositoryAggregationResponse build() {
            return new RepositoryAggregationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryAggregationResponse> {
        public Builder repository(String var1);

        public Builder accountId(String var1);

        public Builder severityCounts(SeverityCounts var1);

        default public Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return this.severityCounts((SeverityCounts)((SeverityCounts.Builder)SeverityCounts.builder().applyMutation(severityCounts)).build());
        }

        public Builder affectedImages(Long var1);
    }
}

