/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector2.model.CisTargetStatus;
import software.amazon.awssdk.services.inspector2.model.CisTargetStatusReason;
import software.amazon.awssdk.services.inspector2.model.StatusCounts;
import software.amazon.awssdk.services.inspector2.model.TargetResourceTagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CisTargetResourceAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CisTargetResourceAggregation> {
    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanArn").getter(CisTargetResourceAggregation.getter(CisTargetResourceAggregation::scanArn)).setter(CisTargetResourceAggregation.setter(Builder::scanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()}).build();
    private static final SdkField<String> TARGET_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetResourceId").getter(CisTargetResourceAggregation.getter(CisTargetResourceAggregation::targetResourceId)).setter(CisTargetResourceAggregation.setter(Builder::targetResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(CisTargetResourceAggregation.getter(CisTargetResourceAggregation::accountId)).setter(CisTargetResourceAggregation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Map<String, List<String>>> TARGET_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("targetResourceTags").getter(CisTargetResourceAggregation.getter(CisTargetResourceAggregation::targetResourceTags)).setter(CisTargetResourceAggregation.setter(Builder::targetResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<StatusCounts> STATUS_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusCounts").getter(CisTargetResourceAggregation.getter(CisTargetResourceAggregation::statusCounts)).setter(CisTargetResourceAggregation.setter(Builder::statusCounts)).constructor(StatusCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCounts").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(CisTargetResourceAggregation.getter(CisTargetResourceAggregation::platform)).setter(CisTargetResourceAggregation.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetStatus").getter(CisTargetResourceAggregation.getter(CisTargetResourceAggregation::targetStatusAsString)).setter(CisTargetResourceAggregation.setter(Builder::targetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStatus").build()}).build();
    private static final SdkField<String> TARGET_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetStatusReason").getter(CisTargetResourceAggregation.getter(CisTargetResourceAggregation::targetStatusReasonAsString)).setter(CisTargetResourceAggregation.setter(Builder::targetStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_ARN_FIELD, TARGET_RESOURCE_ID_FIELD, ACCOUNT_ID_FIELD, TARGET_RESOURCE_TAGS_FIELD, STATUS_COUNTS_FIELD, PLATFORM_FIELD, TARGET_STATUS_FIELD, TARGET_STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CisTargetResourceAggregation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scanArn;
    private final String targetResourceId;
    private final String accountId;
    private final Map<String, List<String>> targetResourceTags;
    private final StatusCounts statusCounts;
    private final String platform;
    private final String targetStatus;
    private final String targetStatusReason;

    private CisTargetResourceAggregation(BuilderImpl builder) {
        this.scanArn = builder.scanArn;
        this.targetResourceId = builder.targetResourceId;
        this.accountId = builder.accountId;
        this.targetResourceTags = builder.targetResourceTags;
        this.statusCounts = builder.statusCounts;
        this.platform = builder.platform;
        this.targetStatus = builder.targetStatus;
        this.targetStatusReason = builder.targetStatusReason;
    }

    public final String scanArn() {
        return this.scanArn;
    }

    public final String targetResourceId() {
        return this.targetResourceId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final boolean hasTargetResourceTags() {
        return this.targetResourceTags != null && !(this.targetResourceTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> targetResourceTags() {
        return this.targetResourceTags;
    }

    public final StatusCounts statusCounts() {
        return this.statusCounts;
    }

    public final String platform() {
        return this.platform;
    }

    public final CisTargetStatus targetStatus() {
        return CisTargetStatus.fromValue(this.targetStatus);
    }

    public final String targetStatusAsString() {
        return this.targetStatus;
    }

    public final CisTargetStatusReason targetStatusReason() {
        return CisTargetStatusReason.fromValue(this.targetStatusReason);
    }

    public final String targetStatusReasonAsString() {
        return this.targetStatusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetResourceTags() ? this.targetResourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetStatusReasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisTargetResourceAggregation)) {
            return false;
        }
        CisTargetResourceAggregation other = (CisTargetResourceAggregation)obj;
        return Objects.equals(this.scanArn(), other.scanArn()) && Objects.equals(this.targetResourceId(), other.targetResourceId()) && Objects.equals(this.accountId(), other.accountId()) && this.hasTargetResourceTags() == other.hasTargetResourceTags() && Objects.equals(this.targetResourceTags(), other.targetResourceTags()) && Objects.equals(this.statusCounts(), other.statusCounts()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.targetStatusAsString(), other.targetStatusAsString()) && Objects.equals(this.targetStatusReasonAsString(), other.targetStatusReasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CisTargetResourceAggregation").add("ScanArn", (Object)this.scanArn()).add("TargetResourceId", (Object)this.targetResourceId()).add("AccountId", (Object)this.accountId()).add("TargetResourceTags", this.hasTargetResourceTags() ? this.targetResourceTags() : null).add("StatusCounts", (Object)this.statusCounts()).add("Platform", (Object)this.platform()).add("TargetStatus", (Object)this.targetStatusAsString()).add("TargetStatusReason", (Object)this.targetStatusReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scanArn": {
                return Optional.ofNullable(clazz.cast(this.scanArn()));
            }
            case "targetResourceId": {
                return Optional.ofNullable(clazz.cast(this.targetResourceId()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "targetResourceTags": {
                return Optional.ofNullable(clazz.cast(this.targetResourceTags()));
            }
            case "statusCounts": {
                return Optional.ofNullable(clazz.cast(this.statusCounts()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "targetStatus": {
                return Optional.ofNullable(clazz.cast(this.targetStatusAsString()));
            }
            case "targetStatusReason": {
                return Optional.ofNullable(clazz.cast(this.targetStatusReasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scanArn", SCAN_ARN_FIELD);
        map.put("targetResourceId", TARGET_RESOURCE_ID_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("targetResourceTags", TARGET_RESOURCE_TAGS_FIELD);
        map.put("statusCounts", STATUS_COUNTS_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("targetStatus", TARGET_STATUS_FIELD);
        map.put("targetStatusReason", TARGET_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisTargetResourceAggregation, T> g) {
        return obj -> g.apply((CisTargetResourceAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scanArn;
        private String targetResourceId;
        private String accountId;
        private Map<String, List<String>> targetResourceTags = DefaultSdkAutoConstructMap.getInstance();
        private StatusCounts statusCounts;
        private String platform;
        private String targetStatus;
        private String targetStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CisTargetResourceAggregation model) {
            this.scanArn(model.scanArn);
            this.targetResourceId(model.targetResourceId);
            this.accountId(model.accountId);
            this.targetResourceTags(model.targetResourceTags);
            this.statusCounts(model.statusCounts);
            this.platform(model.platform);
            this.targetStatus(model.targetStatus);
            this.targetStatusReason(model.targetStatusReason);
        }

        public final String getScanArn() {
            return this.scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final String getTargetResourceId() {
            return this.targetResourceId;
        }

        public final void setTargetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
        }

        @Override
        public final Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getTargetResourceTags() {
            if (this.targetResourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.targetResourceTags;
        }

        public final void setTargetResourceTags(Map<String, ? extends Collection<String>> targetResourceTags) {
            this.targetResourceTags = TargetResourceTagsCopier.copy(targetResourceTags);
        }

        @Override
        public final Builder targetResourceTags(Map<String, ? extends Collection<String>> targetResourceTags) {
            this.targetResourceTags = TargetResourceTagsCopier.copy(targetResourceTags);
            return this;
        }

        public final StatusCounts.Builder getStatusCounts() {
            return this.statusCounts != null ? this.statusCounts.toBuilder() : null;
        }

        public final void setStatusCounts(StatusCounts.BuilderImpl statusCounts) {
            this.statusCounts = statusCounts != null ? statusCounts.build() : null;
        }

        @Override
        public final Builder statusCounts(StatusCounts statusCounts) {
            this.statusCounts = statusCounts;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getTargetStatus() {
            return this.targetStatus;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(CisTargetStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        public final String getTargetStatusReason() {
            return this.targetStatusReason;
        }

        public final void setTargetStatusReason(String targetStatusReason) {
            this.targetStatusReason = targetStatusReason;
        }

        @Override
        public final Builder targetStatusReason(String targetStatusReason) {
            this.targetStatusReason = targetStatusReason;
            return this;
        }

        @Override
        public final Builder targetStatusReason(CisTargetStatusReason targetStatusReason) {
            this.targetStatusReason(targetStatusReason == null ? null : targetStatusReason.toString());
            return this;
        }

        public CisTargetResourceAggregation build() {
            return new CisTargetResourceAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CisTargetResourceAggregation> {
        public Builder scanArn(String var1);

        public Builder targetResourceId(String var1);

        public Builder accountId(String var1);

        public Builder targetResourceTags(Map<String, ? extends Collection<String>> var1);

        public Builder statusCounts(StatusCounts var1);

        default public Builder statusCounts(Consumer<StatusCounts.Builder> statusCounts) {
            return this.statusCounts((StatusCounts)((StatusCounts.Builder)StatusCounts.builder().applyMutation(statusCounts)).build());
        }

        public Builder platform(String var1);

        public Builder targetStatus(String var1);

        public Builder targetStatus(CisTargetStatus var1);

        public Builder targetStatusReason(String var1);

        public Builder targetStatusReason(CisTargetStatusReason var1);
    }
}

