/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CisRuleStatus {
    FAILED("FAILED"),
    PASSED("PASSED"),
    NOT_EVALUATED("NOT_EVALUATED"),
    INFORMATIONAL("INFORMATIONAL"),
    UNKNOWN("UNKNOWN"),
    NOT_APPLICABLE("NOT_APPLICABLE"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CisRuleStatus> VALUE_MAP;
    private final String value;

    private CisRuleStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CisRuleStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CisRuleStatus> knownValues() {
        EnumSet<CisRuleStatus> knownValues = EnumSet.allOf(CisRuleStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CisRuleStatus.class, CisRuleStatus::toString);
    }
}

