/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.PeriodicScanFrequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PeriodicScanConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PeriodicScanConfiguration> {
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frequency").getter(PeriodicScanConfiguration.getter(PeriodicScanConfiguration::frequencyAsString)).setter(PeriodicScanConfiguration.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final SdkField<String> FREQUENCY_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frequencyExpression").getter(PeriodicScanConfiguration.getter(PeriodicScanConfiguration::frequencyExpression)).setter(PeriodicScanConfiguration.setter(Builder::frequencyExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequencyExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD, FREQUENCY_EXPRESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PeriodicScanConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String frequency;
    private final String frequencyExpression;

    private PeriodicScanConfiguration(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.frequencyExpression = builder.frequencyExpression;
    }

    public final PeriodicScanFrequency frequency() {
        return PeriodicScanFrequency.fromValue(this.frequency);
    }

    public final String frequencyAsString() {
        return this.frequency;
    }

    public final String frequencyExpression() {
        return this.frequencyExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PeriodicScanConfiguration)) {
            return false;
        }
        PeriodicScanConfiguration other = (PeriodicScanConfiguration)obj;
        return Objects.equals(this.frequencyAsString(), other.frequencyAsString()) && Objects.equals(this.frequencyExpression(), other.frequencyExpression());
    }

    public final String toString() {
        return ToString.builder((String)"PeriodicScanConfiguration").add("Frequency", (Object)this.frequencyAsString()).add("FrequencyExpression", (Object)this.frequencyExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
            case "frequencyExpression": {
                return Optional.ofNullable(clazz.cast(this.frequencyExpression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("frequency", FREQUENCY_FIELD);
        map.put("frequencyExpression", FREQUENCY_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PeriodicScanConfiguration, T> g) {
        return obj -> g.apply((PeriodicScanConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String frequency;
        private String frequencyExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(PeriodicScanConfiguration model) {
            this.frequency(model.frequency);
            this.frequencyExpression(model.frequencyExpression);
        }

        public final String getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(PeriodicScanFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final String getFrequencyExpression() {
            return this.frequencyExpression;
        }

        public final void setFrequencyExpression(String frequencyExpression) {
            this.frequencyExpression = frequencyExpression;
        }

        @Override
        public final Builder frequencyExpression(String frequencyExpression) {
            this.frequencyExpression = frequencyExpression;
            return this;
        }

        public PeriodicScanConfiguration build() {
            return new PeriodicScanConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PeriodicScanConfiguration> {
        public Builder frequency(String var1);

        public Builder frequency(PeriodicScanFrequency var1);

        public Builder frequencyExpression(String var1);
    }
}

