/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.RelationshipStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Member
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Member> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(Member.getter(Member::accountId)).setter(Member.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> RELATIONSHIP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationshipStatus").getter(Member.getter(Member::relationshipStatusAsString)).setter(Member.setter(Builder::relationshipStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipStatus").build()}).build();
    private static final SdkField<String> DELEGATED_ADMIN_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("delegatedAdminAccountId").getter(Member.getter(Member::delegatedAdminAccountId)).setter(Member.setter(Builder::delegatedAdminAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegatedAdminAccountId").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Member.getter(Member::updatedAt)).setter(Member.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, RELATIONSHIP_STATUS_FIELD, DELEGATED_ADMIN_ACCOUNT_ID_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Member.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String relationshipStatus;
    private final String delegatedAdminAccountId;
    private final Instant updatedAt;

    private Member(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.relationshipStatus = builder.relationshipStatus;
        this.delegatedAdminAccountId = builder.delegatedAdminAccountId;
        this.updatedAt = builder.updatedAt;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final RelationshipStatus relationshipStatus() {
        return RelationshipStatus.fromValue(this.relationshipStatus);
    }

    public final String relationshipStatusAsString() {
        return this.relationshipStatus;
    }

    public final String delegatedAdminAccountId() {
        return this.delegatedAdminAccountId;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegatedAdminAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.relationshipStatusAsString(), other.relationshipStatusAsString()) && Objects.equals(this.delegatedAdminAccountId(), other.delegatedAdminAccountId()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"Member").add("AccountId", (Object)this.accountId()).add("RelationshipStatus", (Object)this.relationshipStatusAsString()).add("DelegatedAdminAccountId", (Object)this.delegatedAdminAccountId()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "relationshipStatus": {
                return Optional.ofNullable(clazz.cast(this.relationshipStatusAsString()));
            }
            case "delegatedAdminAccountId": {
                return Optional.ofNullable(clazz.cast(this.delegatedAdminAccountId()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("relationshipStatus", RELATIONSHIP_STATUS_FIELD);
        map.put("delegatedAdminAccountId", DELEGATED_ADMIN_ACCOUNT_ID_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Member, T> g) {
        return obj -> g.apply((Member)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String relationshipStatus;
        private String delegatedAdminAccountId;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            this.accountId(model.accountId);
            this.relationshipStatus(model.relationshipStatus);
            this.delegatedAdminAccountId(model.delegatedAdminAccountId);
            this.updatedAt(model.updatedAt);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRelationshipStatus() {
            return this.relationshipStatus;
        }

        public final void setRelationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
        }

        @Override
        public final Builder relationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
            return this;
        }

        @Override
        public final Builder relationshipStatus(RelationshipStatus relationshipStatus) {
            this.relationshipStatus(relationshipStatus == null ? null : relationshipStatus.toString());
            return this;
        }

        public final String getDelegatedAdminAccountId() {
            return this.delegatedAdminAccountId;
        }

        public final void setDelegatedAdminAccountId(String delegatedAdminAccountId) {
            this.delegatedAdminAccountId = delegatedAdminAccountId;
        }

        @Override
        public final Builder delegatedAdminAccountId(String delegatedAdminAccountId) {
            this.delegatedAdminAccountId = delegatedAdminAccountId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Member build() {
            return new Member(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Member> {
        public Builder accountId(String var1);

        public Builder relationshipStatus(String var1);

        public Builder relationshipStatus(RelationshipStatus var1);

        public Builder delegatedAdminAccountId(String var1);

        public Builder updatedAt(Instant var1);
    }
}

