/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CodeSecurityScanConfigurationAssociationSummariesCopier;
import software.amazon.awssdk.services.inspector2.model.CodeSecurityScanConfigurationAssociationSummary;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCodeSecurityScanConfigurationAssociationsResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, ListCodeSecurityScanConfigurationAssociationsResponse> {
    private static final SdkField<List<CodeSecurityScanConfigurationAssociationSummary>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associations").getter(ListCodeSecurityScanConfigurationAssociationsResponse.getter(ListCodeSecurityScanConfigurationAssociationsResponse::associations)).setter(ListCodeSecurityScanConfigurationAssociationsResponse.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeSecurityScanConfigurationAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCodeSecurityScanConfigurationAssociationsResponse.getter(ListCodeSecurityScanConfigurationAssociationsResponse::nextToken)).setter(ListCodeSecurityScanConfigurationAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCodeSecurityScanConfigurationAssociationsResponse.memberNameToFieldInitializer();
    private final List<CodeSecurityScanConfigurationAssociationSummary> associations;
    private final String nextToken;

    private ListCodeSecurityScanConfigurationAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<CodeSecurityScanConfigurationAssociationSummary> associations() {
        return this.associations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeSecurityScanConfigurationAssociationsResponse)) {
            return false;
        }
        ListCodeSecurityScanConfigurationAssociationsResponse other = (ListCodeSecurityScanConfigurationAssociationsResponse)((Object)obj);
        return this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCodeSecurityScanConfigurationAssociationsResponse").add("Associations", this.hasAssociations() ? this.associations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("associations", ASSOCIATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCodeSecurityScanConfigurationAssociationsResponse, T> g) {
        return obj -> g.apply((ListCodeSecurityScanConfigurationAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<CodeSecurityScanConfigurationAssociationSummary> associations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeSecurityScanConfigurationAssociationsResponse model) {
            super(model);
            this.associations(model.associations);
            this.nextToken(model.nextToken);
        }

        public final List<CodeSecurityScanConfigurationAssociationSummary.Builder> getAssociations() {
            List<CodeSecurityScanConfigurationAssociationSummary.Builder> result = CodeSecurityScanConfigurationAssociationSummariesCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<CodeSecurityScanConfigurationAssociationSummary.BuilderImpl> associations) {
            this.associations = CodeSecurityScanConfigurationAssociationSummariesCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<CodeSecurityScanConfigurationAssociationSummary> associations) {
            this.associations = CodeSecurityScanConfigurationAssociationSummariesCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(CodeSecurityScanConfigurationAssociationSummary ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<CodeSecurityScanConfigurationAssociationSummary.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (CodeSecurityScanConfigurationAssociationSummary)((CodeSecurityScanConfigurationAssociationSummary.Builder)CodeSecurityScanConfigurationAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCodeSecurityScanConfigurationAssociationsResponse build() {
            return new ListCodeSecurityScanConfigurationAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCodeSecurityScanConfigurationAssociationsResponse> {
        public Builder associations(Collection<CodeSecurityScanConfigurationAssociationSummary> var1);

        public Builder associations(CodeSecurityScanConfigurationAssociationSummary ... var1);

        public Builder associations(Consumer<CodeSecurityScanConfigurationAssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

