/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregation;
import software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregationListCopier;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCisScanResultsAggregatedByTargetResourceResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, ListCisScanResultsAggregatedByTargetResourceResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCisScanResultsAggregatedByTargetResourceResponse.getter(ListCisScanResultsAggregatedByTargetResourceResponse::nextToken)).setter(ListCisScanResultsAggregatedByTargetResourceResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CisTargetResourceAggregation>> TARGET_RESOURCE_AGGREGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetResourceAggregations").getter(ListCisScanResultsAggregatedByTargetResourceResponse.getter(ListCisScanResultsAggregatedByTargetResourceResponse::targetResourceAggregations)).setter(ListCisScanResultsAggregatedByTargetResourceResponse.setter(Builder::targetResourceAggregations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceAggregations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisTargetResourceAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TARGET_RESOURCE_AGGREGATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCisScanResultsAggregatedByTargetResourceResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CisTargetResourceAggregation> targetResourceAggregations;

    private ListCisScanResultsAggregatedByTargetResourceResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.targetResourceAggregations = builder.targetResourceAggregations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTargetResourceAggregations() {
        return this.targetResourceAggregations != null && !(this.targetResourceAggregations instanceof SdkAutoConstructList);
    }

    public final List<CisTargetResourceAggregation> targetResourceAggregations() {
        return this.targetResourceAggregations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetResourceAggregations() ? this.targetResourceAggregations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCisScanResultsAggregatedByTargetResourceResponse)) {
            return false;
        }
        ListCisScanResultsAggregatedByTargetResourceResponse other = (ListCisScanResultsAggregatedByTargetResourceResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTargetResourceAggregations() == other.hasTargetResourceAggregations() && Objects.equals(this.targetResourceAggregations(), other.targetResourceAggregations());
    }

    public final String toString() {
        return ToString.builder((String)"ListCisScanResultsAggregatedByTargetResourceResponse").add("NextToken", (Object)this.nextToken()).add("TargetResourceAggregations", this.hasTargetResourceAggregations() ? this.targetResourceAggregations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "targetResourceAggregations": {
                return Optional.ofNullable(clazz.cast(this.targetResourceAggregations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("targetResourceAggregations", TARGET_RESOURCE_AGGREGATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCisScanResultsAggregatedByTargetResourceResponse, T> g) {
        return obj -> g.apply((ListCisScanResultsAggregatedByTargetResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CisTargetResourceAggregation> targetResourceAggregations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCisScanResultsAggregatedByTargetResourceResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.targetResourceAggregations(model.targetResourceAggregations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CisTargetResourceAggregation.Builder> getTargetResourceAggregations() {
            List<CisTargetResourceAggregation.Builder> result = CisTargetResourceAggregationListCopier.copyToBuilder(this.targetResourceAggregations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceAggregations(Collection<CisTargetResourceAggregation.BuilderImpl> targetResourceAggregations) {
            this.targetResourceAggregations = CisTargetResourceAggregationListCopier.copyFromBuilder(targetResourceAggregations);
        }

        @Override
        public final Builder targetResourceAggregations(Collection<CisTargetResourceAggregation> targetResourceAggregations) {
            this.targetResourceAggregations = CisTargetResourceAggregationListCopier.copy(targetResourceAggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceAggregations(CisTargetResourceAggregation ... targetResourceAggregations) {
            this.targetResourceAggregations(Arrays.asList(targetResourceAggregations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceAggregations(Consumer<CisTargetResourceAggregation.Builder> ... targetResourceAggregations) {
            this.targetResourceAggregations(Stream.of(targetResourceAggregations).map(c -> (CisTargetResourceAggregation)((CisTargetResourceAggregation.Builder)CisTargetResourceAggregation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCisScanResultsAggregatedByTargetResourceResponse build() {
            return new ListCisScanResultsAggregatedByTargetResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCisScanResultsAggregatedByTargetResourceResponse> {
        public Builder nextToken(String var1);

        public Builder targetResourceAggregations(Collection<CisTargetResourceAggregation> var1);

        public Builder targetResourceAggregations(CisTargetResourceAggregation ... var1);

        public Builder targetResourceAggregations(Consumer<CisTargetResourceAggregation.Builder> ... var1);
    }
}

