/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CoverageDateFilter;
import software.amazon.awssdk.services.inspector2.model.CoverageDateFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CoverageMapFilter;
import software.amazon.awssdk.services.inspector2.model.CoverageMapFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CoverageStringFilter;
import software.amazon.awssdk.services.inspector2.model.CoverageStringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoverageFilterCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoverageFilterCriteria> {
    private static final SdkField<List<CoverageStringFilter>> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountId").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::accountId)).setter(CoverageFilterCriteria.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageMapFilter>> EC2_INSTANCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ec2InstanceTags").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::ec2InstanceTags)).setter(CoverageFilterCriteria.setter(Builder::ec2InstanceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageMapFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageStringFilter>> ECR_IMAGE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ecrImageTags").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::ecrImageTags)).setter(CoverageFilterCriteria.setter(Builder::ecrImageTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImageTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageStringFilter>> ECR_REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ecrRepositoryName").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::ecrRepositoryName)).setter(CoverageFilterCriteria.setter(Builder::ecrRepositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryName").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageDateFilter>> IMAGE_PULLED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imagePulledAt").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::imagePulledAt)).setter(CoverageFilterCriteria.setter(Builder::imagePulledAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePulledAt").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageDateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageStringFilter>> LAMBDA_FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lambdaFunctionName").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::lambdaFunctionName)).setter(CoverageFilterCriteria.setter(Builder::lambdaFunctionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionName").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageStringFilter>> LAMBDA_FUNCTION_RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lambdaFunctionRuntime").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::lambdaFunctionRuntime)).setter(CoverageFilterCriteria.setter(Builder::lambdaFunctionRuntime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionRuntime").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageMapFilter>> LAMBDA_FUNCTION_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lambdaFunctionTags").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::lambdaFunctionTags)).setter(CoverageFilterCriteria.setter(Builder::lambdaFunctionTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageMapFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageDateFilter>> LAST_SCANNED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lastScannedAt").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::lastScannedAt)).setter(CoverageFilterCriteria.setter(Builder::lastScannedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastScannedAt").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageDateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageStringFilter>> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceId").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::resourceId)).setter(CoverageFilterCriteria.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageStringFilter>> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceType").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::resourceType)).setter(CoverageFilterCriteria.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageStringFilter>> SCAN_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanMode").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::scanMode)).setter(CoverageFilterCriteria.setter(Builder::scanMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanMode").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageStringFilter>> SCAN_STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanStatusCode").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::scanStatusCode)).setter(CoverageFilterCriteria.setter(Builder::scanStatusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatusCode").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageStringFilter>> SCAN_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanStatusReason").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::scanStatusReason)).setter(CoverageFilterCriteria.setter(Builder::scanStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatusReason").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoverageStringFilter>> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanType").getter(CoverageFilterCriteria.getter(CoverageFilterCriteria::scanType)).setter(CoverageFilterCriteria.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, EC2_INSTANCE_TAGS_FIELD, ECR_IMAGE_TAGS_FIELD, ECR_REPOSITORY_NAME_FIELD, IMAGE_PULLED_AT_FIELD, LAMBDA_FUNCTION_NAME_FIELD, LAMBDA_FUNCTION_RUNTIME_FIELD, LAMBDA_FUNCTION_TAGS_FIELD, LAST_SCANNED_AT_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, SCAN_MODE_FIELD, SCAN_STATUS_CODE_FIELD, SCAN_STATUS_REASON_FIELD, SCAN_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CoverageFilterCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<CoverageStringFilter> accountId;
    private final List<CoverageMapFilter> ec2InstanceTags;
    private final List<CoverageStringFilter> ecrImageTags;
    private final List<CoverageStringFilter> ecrRepositoryName;
    private final List<CoverageDateFilter> imagePulledAt;
    private final List<CoverageStringFilter> lambdaFunctionName;
    private final List<CoverageStringFilter> lambdaFunctionRuntime;
    private final List<CoverageMapFilter> lambdaFunctionTags;
    private final List<CoverageDateFilter> lastScannedAt;
    private final List<CoverageStringFilter> resourceId;
    private final List<CoverageStringFilter> resourceType;
    private final List<CoverageStringFilter> scanMode;
    private final List<CoverageStringFilter> scanStatusCode;
    private final List<CoverageStringFilter> scanStatusReason;
    private final List<CoverageStringFilter> scanType;

    private CoverageFilterCriteria(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.ec2InstanceTags = builder.ec2InstanceTags;
        this.ecrImageTags = builder.ecrImageTags;
        this.ecrRepositoryName = builder.ecrRepositoryName;
        this.imagePulledAt = builder.imagePulledAt;
        this.lambdaFunctionName = builder.lambdaFunctionName;
        this.lambdaFunctionRuntime = builder.lambdaFunctionRuntime;
        this.lambdaFunctionTags = builder.lambdaFunctionTags;
        this.lastScannedAt = builder.lastScannedAt;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.scanMode = builder.scanMode;
        this.scanStatusCode = builder.scanStatusCode;
        this.scanStatusReason = builder.scanStatusReason;
        this.scanType = builder.scanType;
    }

    public final boolean hasAccountId() {
        return this.accountId != null && !(this.accountId instanceof SdkAutoConstructList);
    }

    public final List<CoverageStringFilter> accountId() {
        return this.accountId;
    }

    public final boolean hasEc2InstanceTags() {
        return this.ec2InstanceTags != null && !(this.ec2InstanceTags instanceof SdkAutoConstructList);
    }

    public final List<CoverageMapFilter> ec2InstanceTags() {
        return this.ec2InstanceTags;
    }

    public final boolean hasEcrImageTags() {
        return this.ecrImageTags != null && !(this.ecrImageTags instanceof SdkAutoConstructList);
    }

    public final List<CoverageStringFilter> ecrImageTags() {
        return this.ecrImageTags;
    }

    public final boolean hasEcrRepositoryName() {
        return this.ecrRepositoryName != null && !(this.ecrRepositoryName instanceof SdkAutoConstructList);
    }

    public final List<CoverageStringFilter> ecrRepositoryName() {
        return this.ecrRepositoryName;
    }

    public final boolean hasImagePulledAt() {
        return this.imagePulledAt != null && !(this.imagePulledAt instanceof SdkAutoConstructList);
    }

    public final List<CoverageDateFilter> imagePulledAt() {
        return this.imagePulledAt;
    }

    public final boolean hasLambdaFunctionName() {
        return this.lambdaFunctionName != null && !(this.lambdaFunctionName instanceof SdkAutoConstructList);
    }

    public final List<CoverageStringFilter> lambdaFunctionName() {
        return this.lambdaFunctionName;
    }

    public final boolean hasLambdaFunctionRuntime() {
        return this.lambdaFunctionRuntime != null && !(this.lambdaFunctionRuntime instanceof SdkAutoConstructList);
    }

    public final List<CoverageStringFilter> lambdaFunctionRuntime() {
        return this.lambdaFunctionRuntime;
    }

    public final boolean hasLambdaFunctionTags() {
        return this.lambdaFunctionTags != null && !(this.lambdaFunctionTags instanceof SdkAutoConstructList);
    }

    public final List<CoverageMapFilter> lambdaFunctionTags() {
        return this.lambdaFunctionTags;
    }

    public final boolean hasLastScannedAt() {
        return this.lastScannedAt != null && !(this.lastScannedAt instanceof SdkAutoConstructList);
    }

    public final List<CoverageDateFilter> lastScannedAt() {
        return this.lastScannedAt;
    }

    public final boolean hasResourceId() {
        return this.resourceId != null && !(this.resourceId instanceof SdkAutoConstructList);
    }

    public final List<CoverageStringFilter> resourceId() {
        return this.resourceId;
    }

    public final boolean hasResourceType() {
        return this.resourceType != null && !(this.resourceType instanceof SdkAutoConstructList);
    }

    public final List<CoverageStringFilter> resourceType() {
        return this.resourceType;
    }

    public final boolean hasScanMode() {
        return this.scanMode != null && !(this.scanMode instanceof SdkAutoConstructList);
    }

    public final List<CoverageStringFilter> scanMode() {
        return this.scanMode;
    }

    public final boolean hasScanStatusCode() {
        return this.scanStatusCode != null && !(this.scanStatusCode instanceof SdkAutoConstructList);
    }

    public final List<CoverageStringFilter> scanStatusCode() {
        return this.scanStatusCode;
    }

    public final boolean hasScanStatusReason() {
        return this.scanStatusReason != null && !(this.scanStatusReason instanceof SdkAutoConstructList);
    }

    public final List<CoverageStringFilter> scanStatusReason() {
        return this.scanStatusReason;
    }

    public final boolean hasScanType() {
        return this.scanType != null && !(this.scanType instanceof SdkAutoConstructList);
    }

    public final List<CoverageStringFilter> scanType() {
        return this.scanType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountId() ? this.accountId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2InstanceTags() ? this.ec2InstanceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEcrImageTags() ? this.ecrImageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEcrRepositoryName() ? this.ecrRepositoryName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImagePulledAt() ? this.imagePulledAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLambdaFunctionName() ? this.lambdaFunctionName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLambdaFunctionRuntime() ? this.lambdaFunctionRuntime() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLambdaFunctionTags() ? this.lambdaFunctionTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLastScannedAt() ? this.lastScannedAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceId() ? this.resourceId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceType() ? this.resourceType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanMode() ? this.scanMode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanStatusCode() ? this.scanStatusCode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanStatusReason() ? this.scanStatusReason() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanType() ? this.scanType() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageFilterCriteria)) {
            return false;
        }
        CoverageFilterCriteria other = (CoverageFilterCriteria)obj;
        return this.hasAccountId() == other.hasAccountId() && Objects.equals(this.accountId(), other.accountId()) && this.hasEc2InstanceTags() == other.hasEc2InstanceTags() && Objects.equals(this.ec2InstanceTags(), other.ec2InstanceTags()) && this.hasEcrImageTags() == other.hasEcrImageTags() && Objects.equals(this.ecrImageTags(), other.ecrImageTags()) && this.hasEcrRepositoryName() == other.hasEcrRepositoryName() && Objects.equals(this.ecrRepositoryName(), other.ecrRepositoryName()) && this.hasImagePulledAt() == other.hasImagePulledAt() && Objects.equals(this.imagePulledAt(), other.imagePulledAt()) && this.hasLambdaFunctionName() == other.hasLambdaFunctionName() && Objects.equals(this.lambdaFunctionName(), other.lambdaFunctionName()) && this.hasLambdaFunctionRuntime() == other.hasLambdaFunctionRuntime() && Objects.equals(this.lambdaFunctionRuntime(), other.lambdaFunctionRuntime()) && this.hasLambdaFunctionTags() == other.hasLambdaFunctionTags() && Objects.equals(this.lambdaFunctionTags(), other.lambdaFunctionTags()) && this.hasLastScannedAt() == other.hasLastScannedAt() && Objects.equals(this.lastScannedAt(), other.lastScannedAt()) && this.hasResourceId() == other.hasResourceId() && Objects.equals(this.resourceId(), other.resourceId()) && this.hasResourceType() == other.hasResourceType() && Objects.equals(this.resourceType(), other.resourceType()) && this.hasScanMode() == other.hasScanMode() && Objects.equals(this.scanMode(), other.scanMode()) && this.hasScanStatusCode() == other.hasScanStatusCode() && Objects.equals(this.scanStatusCode(), other.scanStatusCode()) && this.hasScanStatusReason() == other.hasScanStatusReason() && Objects.equals(this.scanStatusReason(), other.scanStatusReason()) && this.hasScanType() == other.hasScanType() && Objects.equals(this.scanType(), other.scanType());
    }

    public final String toString() {
        return ToString.builder((String)"CoverageFilterCriteria").add("AccountId", this.hasAccountId() ? this.accountId() : null).add("Ec2InstanceTags", this.hasEc2InstanceTags() ? this.ec2InstanceTags() : null).add("EcrImageTags", this.hasEcrImageTags() ? this.ecrImageTags() : null).add("EcrRepositoryName", this.hasEcrRepositoryName() ? this.ecrRepositoryName() : null).add("ImagePulledAt", this.hasImagePulledAt() ? this.imagePulledAt() : null).add("LambdaFunctionName", this.hasLambdaFunctionName() ? this.lambdaFunctionName() : null).add("LambdaFunctionRuntime", this.hasLambdaFunctionRuntime() ? this.lambdaFunctionRuntime() : null).add("LambdaFunctionTags", this.hasLambdaFunctionTags() ? this.lambdaFunctionTags() : null).add("LastScannedAt", this.hasLastScannedAt() ? this.lastScannedAt() : null).add("ResourceId", this.hasResourceId() ? this.resourceId() : null).add("ResourceType", this.hasResourceType() ? this.resourceType() : null).add("ScanMode", this.hasScanMode() ? this.scanMode() : null).add("ScanStatusCode", this.hasScanStatusCode() ? this.scanStatusCode() : null).add("ScanStatusReason", this.hasScanStatusReason() ? this.scanStatusReason() : null).add("ScanType", this.hasScanType() ? this.scanType() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ec2InstanceTags": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceTags()));
            }
            case "ecrImageTags": {
                return Optional.ofNullable(clazz.cast(this.ecrImageTags()));
            }
            case "ecrRepositoryName": {
                return Optional.ofNullable(clazz.cast(this.ecrRepositoryName()));
            }
            case "imagePulledAt": {
                return Optional.ofNullable(clazz.cast(this.imagePulledAt()));
            }
            case "lambdaFunctionName": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionName()));
            }
            case "lambdaFunctionRuntime": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionRuntime()));
            }
            case "lambdaFunctionTags": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionTags()));
            }
            case "lastScannedAt": {
                return Optional.ofNullable(clazz.cast(this.lastScannedAt()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "scanMode": {
                return Optional.ofNullable(clazz.cast(this.scanMode()));
            }
            case "scanStatusCode": {
                return Optional.ofNullable(clazz.cast(this.scanStatusCode()));
            }
            case "scanStatusReason": {
                return Optional.ofNullable(clazz.cast(this.scanStatusReason()));
            }
            case "scanType": {
                return Optional.ofNullable(clazz.cast(this.scanType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("ec2InstanceTags", EC2_INSTANCE_TAGS_FIELD);
        map.put("ecrImageTags", ECR_IMAGE_TAGS_FIELD);
        map.put("ecrRepositoryName", ECR_REPOSITORY_NAME_FIELD);
        map.put("imagePulledAt", IMAGE_PULLED_AT_FIELD);
        map.put("lambdaFunctionName", LAMBDA_FUNCTION_NAME_FIELD);
        map.put("lambdaFunctionRuntime", LAMBDA_FUNCTION_RUNTIME_FIELD);
        map.put("lambdaFunctionTags", LAMBDA_FUNCTION_TAGS_FIELD);
        map.put("lastScannedAt", LAST_SCANNED_AT_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("scanMode", SCAN_MODE_FIELD);
        map.put("scanStatusCode", SCAN_STATUS_CODE_FIELD);
        map.put("scanStatusReason", SCAN_STATUS_REASON_FIELD);
        map.put("scanType", SCAN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoverageFilterCriteria, T> g) {
        return obj -> g.apply((CoverageFilterCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CoverageStringFilter> accountId = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageMapFilter> ec2InstanceTags = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageStringFilter> ecrImageTags = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageStringFilter> ecrRepositoryName = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageDateFilter> imagePulledAt = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageStringFilter> lambdaFunctionName = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageStringFilter> lambdaFunctionRuntime = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageMapFilter> lambdaFunctionTags = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageDateFilter> lastScannedAt = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageStringFilter> resourceId = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageStringFilter> resourceType = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageStringFilter> scanMode = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageStringFilter> scanStatusCode = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageStringFilter> scanStatusReason = DefaultSdkAutoConstructList.getInstance();
        private List<CoverageStringFilter> scanType = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageFilterCriteria model) {
            this.accountId(model.accountId);
            this.ec2InstanceTags(model.ec2InstanceTags);
            this.ecrImageTags(model.ecrImageTags);
            this.ecrRepositoryName(model.ecrRepositoryName);
            this.imagePulledAt(model.imagePulledAt);
            this.lambdaFunctionName(model.lambdaFunctionName);
            this.lambdaFunctionRuntime(model.lambdaFunctionRuntime);
            this.lambdaFunctionTags(model.lambdaFunctionTags);
            this.lastScannedAt(model.lastScannedAt);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.scanMode(model.scanMode);
            this.scanStatusCode(model.scanStatusCode);
            this.scanStatusReason(model.scanStatusReason);
            this.scanType(model.scanType);
        }

        public final List<CoverageStringFilter.Builder> getAccountId() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.accountId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountId(Collection<CoverageStringFilter.BuilderImpl> accountId) {
            this.accountId = CoverageStringFilterListCopier.copyFromBuilder(accountId);
        }

        @Override
        public final Builder accountId(Collection<CoverageStringFilter> accountId) {
            this.accountId = CoverageStringFilterListCopier.copy(accountId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountId(CoverageStringFilter ... accountId) {
            this.accountId(Arrays.asList(accountId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountId(Consumer<CoverageStringFilter.Builder> ... accountId) {
            this.accountId(Stream.of(accountId).map(c -> (CoverageStringFilter)((CoverageStringFilter.Builder)CoverageStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageMapFilter.Builder> getEc2InstanceTags() {
            List<CoverageMapFilter.Builder> result = CoverageMapFilterListCopier.copyToBuilder(this.ec2InstanceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InstanceTags(Collection<CoverageMapFilter.BuilderImpl> ec2InstanceTags) {
            this.ec2InstanceTags = CoverageMapFilterListCopier.copyFromBuilder(ec2InstanceTags);
        }

        @Override
        public final Builder ec2InstanceTags(Collection<CoverageMapFilter> ec2InstanceTags) {
            this.ec2InstanceTags = CoverageMapFilterListCopier.copy(ec2InstanceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceTags(CoverageMapFilter ... ec2InstanceTags) {
            this.ec2InstanceTags(Arrays.asList(ec2InstanceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceTags(Consumer<CoverageMapFilter.Builder> ... ec2InstanceTags) {
            this.ec2InstanceTags(Stream.of(ec2InstanceTags).map(c -> (CoverageMapFilter)((CoverageMapFilter.Builder)CoverageMapFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getEcrImageTags() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.ecrImageTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrImageTags(Collection<CoverageStringFilter.BuilderImpl> ecrImageTags) {
            this.ecrImageTags = CoverageStringFilterListCopier.copyFromBuilder(ecrImageTags);
        }

        @Override
        public final Builder ecrImageTags(Collection<CoverageStringFilter> ecrImageTags) {
            this.ecrImageTags = CoverageStringFilterListCopier.copy(ecrImageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageTags(CoverageStringFilter ... ecrImageTags) {
            this.ecrImageTags(Arrays.asList(ecrImageTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageTags(Consumer<CoverageStringFilter.Builder> ... ecrImageTags) {
            this.ecrImageTags(Stream.of(ecrImageTags).map(c -> (CoverageStringFilter)((CoverageStringFilter.Builder)CoverageStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getEcrRepositoryName() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.ecrRepositoryName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrRepositoryName(Collection<CoverageStringFilter.BuilderImpl> ecrRepositoryName) {
            this.ecrRepositoryName = CoverageStringFilterListCopier.copyFromBuilder(ecrRepositoryName);
        }

        @Override
        public final Builder ecrRepositoryName(Collection<CoverageStringFilter> ecrRepositoryName) {
            this.ecrRepositoryName = CoverageStringFilterListCopier.copy(ecrRepositoryName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrRepositoryName(CoverageStringFilter ... ecrRepositoryName) {
            this.ecrRepositoryName(Arrays.asList(ecrRepositoryName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrRepositoryName(Consumer<CoverageStringFilter.Builder> ... ecrRepositoryName) {
            this.ecrRepositoryName(Stream.of(ecrRepositoryName).map(c -> (CoverageStringFilter)((CoverageStringFilter.Builder)CoverageStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageDateFilter.Builder> getImagePulledAt() {
            List<CoverageDateFilter.Builder> result = CoverageDateFilterListCopier.copyToBuilder(this.imagePulledAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImagePulledAt(Collection<CoverageDateFilter.BuilderImpl> imagePulledAt) {
            this.imagePulledAt = CoverageDateFilterListCopier.copyFromBuilder(imagePulledAt);
        }

        @Override
        public final Builder imagePulledAt(Collection<CoverageDateFilter> imagePulledAt) {
            this.imagePulledAt = CoverageDateFilterListCopier.copy(imagePulledAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePulledAt(CoverageDateFilter ... imagePulledAt) {
            this.imagePulledAt(Arrays.asList(imagePulledAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePulledAt(Consumer<CoverageDateFilter.Builder> ... imagePulledAt) {
            this.imagePulledAt(Stream.of(imagePulledAt).map(c -> (CoverageDateFilter)((CoverageDateFilter.Builder)CoverageDateFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getLambdaFunctionName() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.lambdaFunctionName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdaFunctionName(Collection<CoverageStringFilter.BuilderImpl> lambdaFunctionName) {
            this.lambdaFunctionName = CoverageStringFilterListCopier.copyFromBuilder(lambdaFunctionName);
        }

        @Override
        public final Builder lambdaFunctionName(Collection<CoverageStringFilter> lambdaFunctionName) {
            this.lambdaFunctionName = CoverageStringFilterListCopier.copy(lambdaFunctionName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionName(CoverageStringFilter ... lambdaFunctionName) {
            this.lambdaFunctionName(Arrays.asList(lambdaFunctionName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionName(Consumer<CoverageStringFilter.Builder> ... lambdaFunctionName) {
            this.lambdaFunctionName(Stream.of(lambdaFunctionName).map(c -> (CoverageStringFilter)((CoverageStringFilter.Builder)CoverageStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getLambdaFunctionRuntime() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.lambdaFunctionRuntime);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdaFunctionRuntime(Collection<CoverageStringFilter.BuilderImpl> lambdaFunctionRuntime) {
            this.lambdaFunctionRuntime = CoverageStringFilterListCopier.copyFromBuilder(lambdaFunctionRuntime);
        }

        @Override
        public final Builder lambdaFunctionRuntime(Collection<CoverageStringFilter> lambdaFunctionRuntime) {
            this.lambdaFunctionRuntime = CoverageStringFilterListCopier.copy(lambdaFunctionRuntime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionRuntime(CoverageStringFilter ... lambdaFunctionRuntime) {
            this.lambdaFunctionRuntime(Arrays.asList(lambdaFunctionRuntime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionRuntime(Consumer<CoverageStringFilter.Builder> ... lambdaFunctionRuntime) {
            this.lambdaFunctionRuntime(Stream.of(lambdaFunctionRuntime).map(c -> (CoverageStringFilter)((CoverageStringFilter.Builder)CoverageStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageMapFilter.Builder> getLambdaFunctionTags() {
            List<CoverageMapFilter.Builder> result = CoverageMapFilterListCopier.copyToBuilder(this.lambdaFunctionTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdaFunctionTags(Collection<CoverageMapFilter.BuilderImpl> lambdaFunctionTags) {
            this.lambdaFunctionTags = CoverageMapFilterListCopier.copyFromBuilder(lambdaFunctionTags);
        }

        @Override
        public final Builder lambdaFunctionTags(Collection<CoverageMapFilter> lambdaFunctionTags) {
            this.lambdaFunctionTags = CoverageMapFilterListCopier.copy(lambdaFunctionTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionTags(CoverageMapFilter ... lambdaFunctionTags) {
            this.lambdaFunctionTags(Arrays.asList(lambdaFunctionTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionTags(Consumer<CoverageMapFilter.Builder> ... lambdaFunctionTags) {
            this.lambdaFunctionTags(Stream.of(lambdaFunctionTags).map(c -> (CoverageMapFilter)((CoverageMapFilter.Builder)CoverageMapFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageDateFilter.Builder> getLastScannedAt() {
            List<CoverageDateFilter.Builder> result = CoverageDateFilterListCopier.copyToBuilder(this.lastScannedAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastScannedAt(Collection<CoverageDateFilter.BuilderImpl> lastScannedAt) {
            this.lastScannedAt = CoverageDateFilterListCopier.copyFromBuilder(lastScannedAt);
        }

        @Override
        public final Builder lastScannedAt(Collection<CoverageDateFilter> lastScannedAt) {
            this.lastScannedAt = CoverageDateFilterListCopier.copy(lastScannedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastScannedAt(CoverageDateFilter ... lastScannedAt) {
            this.lastScannedAt(Arrays.asList(lastScannedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastScannedAt(Consumer<CoverageDateFilter.Builder> ... lastScannedAt) {
            this.lastScannedAt(Stream.of(lastScannedAt).map(c -> (CoverageDateFilter)((CoverageDateFilter.Builder)CoverageDateFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getResourceId() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.resourceId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceId(Collection<CoverageStringFilter.BuilderImpl> resourceId) {
            this.resourceId = CoverageStringFilterListCopier.copyFromBuilder(resourceId);
        }

        @Override
        public final Builder resourceId(Collection<CoverageStringFilter> resourceId) {
            this.resourceId = CoverageStringFilterListCopier.copy(resourceId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(CoverageStringFilter ... resourceId) {
            this.resourceId(Arrays.asList(resourceId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(Consumer<CoverageStringFilter.Builder> ... resourceId) {
            this.resourceId(Stream.of(resourceId).map(c -> (CoverageStringFilter)((CoverageStringFilter.Builder)CoverageStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getResourceType() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.resourceType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceType(Collection<CoverageStringFilter.BuilderImpl> resourceType) {
            this.resourceType = CoverageStringFilterListCopier.copyFromBuilder(resourceType);
        }

        @Override
        public final Builder resourceType(Collection<CoverageStringFilter> resourceType) {
            this.resourceType = CoverageStringFilterListCopier.copy(resourceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(CoverageStringFilter ... resourceType) {
            this.resourceType(Arrays.asList(resourceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(Consumer<CoverageStringFilter.Builder> ... resourceType) {
            this.resourceType(Stream.of(resourceType).map(c -> (CoverageStringFilter)((CoverageStringFilter.Builder)CoverageStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getScanMode() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.scanMode);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanMode(Collection<CoverageStringFilter.BuilderImpl> scanMode) {
            this.scanMode = CoverageStringFilterListCopier.copyFromBuilder(scanMode);
        }

        @Override
        public final Builder scanMode(Collection<CoverageStringFilter> scanMode) {
            this.scanMode = CoverageStringFilterListCopier.copy(scanMode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanMode(CoverageStringFilter ... scanMode) {
            this.scanMode(Arrays.asList(scanMode));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanMode(Consumer<CoverageStringFilter.Builder> ... scanMode) {
            this.scanMode(Stream.of(scanMode).map(c -> (CoverageStringFilter)((CoverageStringFilter.Builder)CoverageStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getScanStatusCode() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.scanStatusCode);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanStatusCode(Collection<CoverageStringFilter.BuilderImpl> scanStatusCode) {
            this.scanStatusCode = CoverageStringFilterListCopier.copyFromBuilder(scanStatusCode);
        }

        @Override
        public final Builder scanStatusCode(Collection<CoverageStringFilter> scanStatusCode) {
            this.scanStatusCode = CoverageStringFilterListCopier.copy(scanStatusCode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanStatusCode(CoverageStringFilter ... scanStatusCode) {
            this.scanStatusCode(Arrays.asList(scanStatusCode));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanStatusCode(Consumer<CoverageStringFilter.Builder> ... scanStatusCode) {
            this.scanStatusCode(Stream.of(scanStatusCode).map(c -> (CoverageStringFilter)((CoverageStringFilter.Builder)CoverageStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getScanStatusReason() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.scanStatusReason);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanStatusReason(Collection<CoverageStringFilter.BuilderImpl> scanStatusReason) {
            this.scanStatusReason = CoverageStringFilterListCopier.copyFromBuilder(scanStatusReason);
        }

        @Override
        public final Builder scanStatusReason(Collection<CoverageStringFilter> scanStatusReason) {
            this.scanStatusReason = CoverageStringFilterListCopier.copy(scanStatusReason);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanStatusReason(CoverageStringFilter ... scanStatusReason) {
            this.scanStatusReason(Arrays.asList(scanStatusReason));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanStatusReason(Consumer<CoverageStringFilter.Builder> ... scanStatusReason) {
            this.scanStatusReason(Stream.of(scanStatusReason).map(c -> (CoverageStringFilter)((CoverageStringFilter.Builder)CoverageStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getScanType() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.scanType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanType(Collection<CoverageStringFilter.BuilderImpl> scanType) {
            this.scanType = CoverageStringFilterListCopier.copyFromBuilder(scanType);
        }

        @Override
        public final Builder scanType(Collection<CoverageStringFilter> scanType) {
            this.scanType = CoverageStringFilterListCopier.copy(scanType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanType(CoverageStringFilter ... scanType) {
            this.scanType(Arrays.asList(scanType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanType(Consumer<CoverageStringFilter.Builder> ... scanType) {
            this.scanType(Stream.of(scanType).map(c -> (CoverageStringFilter)((CoverageStringFilter.Builder)CoverageStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CoverageFilterCriteria build() {
            return new CoverageFilterCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoverageFilterCriteria> {
        public Builder accountId(Collection<CoverageStringFilter> var1);

        public Builder accountId(CoverageStringFilter ... var1);

        public Builder accountId(Consumer<CoverageStringFilter.Builder> ... var1);

        public Builder ec2InstanceTags(Collection<CoverageMapFilter> var1);

        public Builder ec2InstanceTags(CoverageMapFilter ... var1);

        public Builder ec2InstanceTags(Consumer<CoverageMapFilter.Builder> ... var1);

        public Builder ecrImageTags(Collection<CoverageStringFilter> var1);

        public Builder ecrImageTags(CoverageStringFilter ... var1);

        public Builder ecrImageTags(Consumer<CoverageStringFilter.Builder> ... var1);

        public Builder ecrRepositoryName(Collection<CoverageStringFilter> var1);

        public Builder ecrRepositoryName(CoverageStringFilter ... var1);

        public Builder ecrRepositoryName(Consumer<CoverageStringFilter.Builder> ... var1);

        public Builder imagePulledAt(Collection<CoverageDateFilter> var1);

        public Builder imagePulledAt(CoverageDateFilter ... var1);

        public Builder imagePulledAt(Consumer<CoverageDateFilter.Builder> ... var1);

        public Builder lambdaFunctionName(Collection<CoverageStringFilter> var1);

        public Builder lambdaFunctionName(CoverageStringFilter ... var1);

        public Builder lambdaFunctionName(Consumer<CoverageStringFilter.Builder> ... var1);

        public Builder lambdaFunctionRuntime(Collection<CoverageStringFilter> var1);

        public Builder lambdaFunctionRuntime(CoverageStringFilter ... var1);

        public Builder lambdaFunctionRuntime(Consumer<CoverageStringFilter.Builder> ... var1);

        public Builder lambdaFunctionTags(Collection<CoverageMapFilter> var1);

        public Builder lambdaFunctionTags(CoverageMapFilter ... var1);

        public Builder lambdaFunctionTags(Consumer<CoverageMapFilter.Builder> ... var1);

        public Builder lastScannedAt(Collection<CoverageDateFilter> var1);

        public Builder lastScannedAt(CoverageDateFilter ... var1);

        public Builder lastScannedAt(Consumer<CoverageDateFilter.Builder> ... var1);

        public Builder resourceId(Collection<CoverageStringFilter> var1);

        public Builder resourceId(CoverageStringFilter ... var1);

        public Builder resourceId(Consumer<CoverageStringFilter.Builder> ... var1);

        public Builder resourceType(Collection<CoverageStringFilter> var1);

        public Builder resourceType(CoverageStringFilter ... var1);

        public Builder resourceType(Consumer<CoverageStringFilter.Builder> ... var1);

        public Builder scanMode(Collection<CoverageStringFilter> var1);

        public Builder scanMode(CoverageStringFilter ... var1);

        public Builder scanMode(Consumer<CoverageStringFilter.Builder> ... var1);

        public Builder scanStatusCode(Collection<CoverageStringFilter> var1);

        public Builder scanStatusCode(CoverageStringFilter ... var1);

        public Builder scanStatusCode(Consumer<CoverageStringFilter.Builder> ... var1);

        public Builder scanStatusReason(Collection<CoverageStringFilter> var1);

        public Builder scanStatusReason(CoverageStringFilter ... var1);

        public Builder scanStatusReason(Consumer<CoverageStringFilter.Builder> ... var1);

        public Builder scanType(Collection<CoverageStringFilter> var1);

        public Builder scanType(CoverageStringFilter ... var1);

        public Builder scanType(Consumer<CoverageStringFilter.Builder> ... var1);
    }
}

