/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.ResourceMapFilter;
import software.amazon.awssdk.services.inspector2.model.ResourceMapFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.ResourceStringFilter;
import software.amazon.awssdk.services.inspector2.model.ResourceStringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceFilterCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceFilterCriteria> {
    private static final SdkField<List<ResourceStringFilter>> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountId").getter(ResourceFilterCriteria.getter(ResourceFilterCriteria::accountId)).setter(ResourceFilterCriteria.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceMapFilter>> EC2_INSTANCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ec2InstanceTags").getter(ResourceFilterCriteria.getter(ResourceFilterCriteria::ec2InstanceTags)).setter(ResourceFilterCriteria.setter(Builder::ec2InstanceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceMapFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceStringFilter>> ECR_IMAGE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ecrImageTags").getter(ResourceFilterCriteria.getter(ResourceFilterCriteria::ecrImageTags)).setter(ResourceFilterCriteria.setter(Builder::ecrImageTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImageTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceStringFilter>> ECR_REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ecrRepositoryName").getter(ResourceFilterCriteria.getter(ResourceFilterCriteria::ecrRepositoryName)).setter(ResourceFilterCriteria.setter(Builder::ecrRepositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryName").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceStringFilter>> LAMBDA_FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lambdaFunctionName").getter(ResourceFilterCriteria.getter(ResourceFilterCriteria::lambdaFunctionName)).setter(ResourceFilterCriteria.setter(Builder::lambdaFunctionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionName").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceMapFilter>> LAMBDA_FUNCTION_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lambdaFunctionTags").getter(ResourceFilterCriteria.getter(ResourceFilterCriteria::lambdaFunctionTags)).setter(ResourceFilterCriteria.setter(Builder::lambdaFunctionTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceMapFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceStringFilter>> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceId").getter(ResourceFilterCriteria.getter(ResourceFilterCriteria::resourceId)).setter(ResourceFilterCriteria.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceStringFilter>> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceType").getter(ResourceFilterCriteria.getter(ResourceFilterCriteria::resourceType)).setter(ResourceFilterCriteria.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, EC2_INSTANCE_TAGS_FIELD, ECR_IMAGE_TAGS_FIELD, ECR_REPOSITORY_NAME_FIELD, LAMBDA_FUNCTION_NAME_FIELD, LAMBDA_FUNCTION_TAGS_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceFilterCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ResourceStringFilter> accountId;
    private final List<ResourceMapFilter> ec2InstanceTags;
    private final List<ResourceStringFilter> ecrImageTags;
    private final List<ResourceStringFilter> ecrRepositoryName;
    private final List<ResourceStringFilter> lambdaFunctionName;
    private final List<ResourceMapFilter> lambdaFunctionTags;
    private final List<ResourceStringFilter> resourceId;
    private final List<ResourceStringFilter> resourceType;

    private ResourceFilterCriteria(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.ec2InstanceTags = builder.ec2InstanceTags;
        this.ecrImageTags = builder.ecrImageTags;
        this.ecrRepositoryName = builder.ecrRepositoryName;
        this.lambdaFunctionName = builder.lambdaFunctionName;
        this.lambdaFunctionTags = builder.lambdaFunctionTags;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    public final boolean hasAccountId() {
        return this.accountId != null && !(this.accountId instanceof SdkAutoConstructList);
    }

    public final List<ResourceStringFilter> accountId() {
        return this.accountId;
    }

    public final boolean hasEc2InstanceTags() {
        return this.ec2InstanceTags != null && !(this.ec2InstanceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceMapFilter> ec2InstanceTags() {
        return this.ec2InstanceTags;
    }

    public final boolean hasEcrImageTags() {
        return this.ecrImageTags != null && !(this.ecrImageTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceStringFilter> ecrImageTags() {
        return this.ecrImageTags;
    }

    public final boolean hasEcrRepositoryName() {
        return this.ecrRepositoryName != null && !(this.ecrRepositoryName instanceof SdkAutoConstructList);
    }

    public final List<ResourceStringFilter> ecrRepositoryName() {
        return this.ecrRepositoryName;
    }

    public final boolean hasLambdaFunctionName() {
        return this.lambdaFunctionName != null && !(this.lambdaFunctionName instanceof SdkAutoConstructList);
    }

    public final List<ResourceStringFilter> lambdaFunctionName() {
        return this.lambdaFunctionName;
    }

    public final boolean hasLambdaFunctionTags() {
        return this.lambdaFunctionTags != null && !(this.lambdaFunctionTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceMapFilter> lambdaFunctionTags() {
        return this.lambdaFunctionTags;
    }

    public final boolean hasResourceId() {
        return this.resourceId != null && !(this.resourceId instanceof SdkAutoConstructList);
    }

    public final List<ResourceStringFilter> resourceId() {
        return this.resourceId;
    }

    public final boolean hasResourceType() {
        return this.resourceType != null && !(this.resourceType instanceof SdkAutoConstructList);
    }

    public final List<ResourceStringFilter> resourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountId() ? this.accountId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2InstanceTags() ? this.ec2InstanceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEcrImageTags() ? this.ecrImageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEcrRepositoryName() ? this.ecrRepositoryName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLambdaFunctionName() ? this.lambdaFunctionName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLambdaFunctionTags() ? this.lambdaFunctionTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceId() ? this.resourceId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceType() ? this.resourceType() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceFilterCriteria)) {
            return false;
        }
        ResourceFilterCriteria other = (ResourceFilterCriteria)obj;
        return this.hasAccountId() == other.hasAccountId() && Objects.equals(this.accountId(), other.accountId()) && this.hasEc2InstanceTags() == other.hasEc2InstanceTags() && Objects.equals(this.ec2InstanceTags(), other.ec2InstanceTags()) && this.hasEcrImageTags() == other.hasEcrImageTags() && Objects.equals(this.ecrImageTags(), other.ecrImageTags()) && this.hasEcrRepositoryName() == other.hasEcrRepositoryName() && Objects.equals(this.ecrRepositoryName(), other.ecrRepositoryName()) && this.hasLambdaFunctionName() == other.hasLambdaFunctionName() && Objects.equals(this.lambdaFunctionName(), other.lambdaFunctionName()) && this.hasLambdaFunctionTags() == other.hasLambdaFunctionTags() && Objects.equals(this.lambdaFunctionTags(), other.lambdaFunctionTags()) && this.hasResourceId() == other.hasResourceId() && Objects.equals(this.resourceId(), other.resourceId()) && this.hasResourceType() == other.hasResourceType() && Objects.equals(this.resourceType(), other.resourceType());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceFilterCriteria").add("AccountId", this.hasAccountId() ? this.accountId() : null).add("Ec2InstanceTags", this.hasEc2InstanceTags() ? this.ec2InstanceTags() : null).add("EcrImageTags", this.hasEcrImageTags() ? this.ecrImageTags() : null).add("EcrRepositoryName", this.hasEcrRepositoryName() ? this.ecrRepositoryName() : null).add("LambdaFunctionName", this.hasLambdaFunctionName() ? this.lambdaFunctionName() : null).add("LambdaFunctionTags", this.hasLambdaFunctionTags() ? this.lambdaFunctionTags() : null).add("ResourceId", this.hasResourceId() ? this.resourceId() : null).add("ResourceType", this.hasResourceType() ? this.resourceType() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ec2InstanceTags": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceTags()));
            }
            case "ecrImageTags": {
                return Optional.ofNullable(clazz.cast(this.ecrImageTags()));
            }
            case "ecrRepositoryName": {
                return Optional.ofNullable(clazz.cast(this.ecrRepositoryName()));
            }
            case "lambdaFunctionName": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionName()));
            }
            case "lambdaFunctionTags": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionTags()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("ec2InstanceTags", EC2_INSTANCE_TAGS_FIELD);
        map.put("ecrImageTags", ECR_IMAGE_TAGS_FIELD);
        map.put("ecrRepositoryName", ECR_REPOSITORY_NAME_FIELD);
        map.put("lambdaFunctionName", LAMBDA_FUNCTION_NAME_FIELD);
        map.put("lambdaFunctionTags", LAMBDA_FUNCTION_TAGS_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceFilterCriteria, T> g) {
        return obj -> g.apply((ResourceFilterCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ResourceStringFilter> accountId = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceMapFilter> ec2InstanceTags = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceStringFilter> ecrImageTags = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceStringFilter> ecrRepositoryName = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceStringFilter> lambdaFunctionName = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceMapFilter> lambdaFunctionTags = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceStringFilter> resourceId = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceStringFilter> resourceType = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceFilterCriteria model) {
            this.accountId(model.accountId);
            this.ec2InstanceTags(model.ec2InstanceTags);
            this.ecrImageTags(model.ecrImageTags);
            this.ecrRepositoryName(model.ecrRepositoryName);
            this.lambdaFunctionName(model.lambdaFunctionName);
            this.lambdaFunctionTags(model.lambdaFunctionTags);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
        }

        public final List<ResourceStringFilter.Builder> getAccountId() {
            List<ResourceStringFilter.Builder> result = ResourceStringFilterListCopier.copyToBuilder(this.accountId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountId(Collection<ResourceStringFilter.BuilderImpl> accountId) {
            this.accountId = ResourceStringFilterListCopier.copyFromBuilder(accountId);
        }

        @Override
        public final Builder accountId(Collection<ResourceStringFilter> accountId) {
            this.accountId = ResourceStringFilterListCopier.copy(accountId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountId(ResourceStringFilter ... accountId) {
            this.accountId(Arrays.asList(accountId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountId(Consumer<ResourceStringFilter.Builder> ... accountId) {
            this.accountId(Stream.of(accountId).map(c -> (ResourceStringFilter)((ResourceStringFilter.Builder)ResourceStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceMapFilter.Builder> getEc2InstanceTags() {
            List<ResourceMapFilter.Builder> result = ResourceMapFilterListCopier.copyToBuilder(this.ec2InstanceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InstanceTags(Collection<ResourceMapFilter.BuilderImpl> ec2InstanceTags) {
            this.ec2InstanceTags = ResourceMapFilterListCopier.copyFromBuilder(ec2InstanceTags);
        }

        @Override
        public final Builder ec2InstanceTags(Collection<ResourceMapFilter> ec2InstanceTags) {
            this.ec2InstanceTags = ResourceMapFilterListCopier.copy(ec2InstanceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceTags(ResourceMapFilter ... ec2InstanceTags) {
            this.ec2InstanceTags(Arrays.asList(ec2InstanceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceTags(Consumer<ResourceMapFilter.Builder> ... ec2InstanceTags) {
            this.ec2InstanceTags(Stream.of(ec2InstanceTags).map(c -> (ResourceMapFilter)((ResourceMapFilter.Builder)ResourceMapFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceStringFilter.Builder> getEcrImageTags() {
            List<ResourceStringFilter.Builder> result = ResourceStringFilterListCopier.copyToBuilder(this.ecrImageTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrImageTags(Collection<ResourceStringFilter.BuilderImpl> ecrImageTags) {
            this.ecrImageTags = ResourceStringFilterListCopier.copyFromBuilder(ecrImageTags);
        }

        @Override
        public final Builder ecrImageTags(Collection<ResourceStringFilter> ecrImageTags) {
            this.ecrImageTags = ResourceStringFilterListCopier.copy(ecrImageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageTags(ResourceStringFilter ... ecrImageTags) {
            this.ecrImageTags(Arrays.asList(ecrImageTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageTags(Consumer<ResourceStringFilter.Builder> ... ecrImageTags) {
            this.ecrImageTags(Stream.of(ecrImageTags).map(c -> (ResourceStringFilter)((ResourceStringFilter.Builder)ResourceStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceStringFilter.Builder> getEcrRepositoryName() {
            List<ResourceStringFilter.Builder> result = ResourceStringFilterListCopier.copyToBuilder(this.ecrRepositoryName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrRepositoryName(Collection<ResourceStringFilter.BuilderImpl> ecrRepositoryName) {
            this.ecrRepositoryName = ResourceStringFilterListCopier.copyFromBuilder(ecrRepositoryName);
        }

        @Override
        public final Builder ecrRepositoryName(Collection<ResourceStringFilter> ecrRepositoryName) {
            this.ecrRepositoryName = ResourceStringFilterListCopier.copy(ecrRepositoryName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrRepositoryName(ResourceStringFilter ... ecrRepositoryName) {
            this.ecrRepositoryName(Arrays.asList(ecrRepositoryName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrRepositoryName(Consumer<ResourceStringFilter.Builder> ... ecrRepositoryName) {
            this.ecrRepositoryName(Stream.of(ecrRepositoryName).map(c -> (ResourceStringFilter)((ResourceStringFilter.Builder)ResourceStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceStringFilter.Builder> getLambdaFunctionName() {
            List<ResourceStringFilter.Builder> result = ResourceStringFilterListCopier.copyToBuilder(this.lambdaFunctionName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdaFunctionName(Collection<ResourceStringFilter.BuilderImpl> lambdaFunctionName) {
            this.lambdaFunctionName = ResourceStringFilterListCopier.copyFromBuilder(lambdaFunctionName);
        }

        @Override
        public final Builder lambdaFunctionName(Collection<ResourceStringFilter> lambdaFunctionName) {
            this.lambdaFunctionName = ResourceStringFilterListCopier.copy(lambdaFunctionName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionName(ResourceStringFilter ... lambdaFunctionName) {
            this.lambdaFunctionName(Arrays.asList(lambdaFunctionName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionName(Consumer<ResourceStringFilter.Builder> ... lambdaFunctionName) {
            this.lambdaFunctionName(Stream.of(lambdaFunctionName).map(c -> (ResourceStringFilter)((ResourceStringFilter.Builder)ResourceStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceMapFilter.Builder> getLambdaFunctionTags() {
            List<ResourceMapFilter.Builder> result = ResourceMapFilterListCopier.copyToBuilder(this.lambdaFunctionTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdaFunctionTags(Collection<ResourceMapFilter.BuilderImpl> lambdaFunctionTags) {
            this.lambdaFunctionTags = ResourceMapFilterListCopier.copyFromBuilder(lambdaFunctionTags);
        }

        @Override
        public final Builder lambdaFunctionTags(Collection<ResourceMapFilter> lambdaFunctionTags) {
            this.lambdaFunctionTags = ResourceMapFilterListCopier.copy(lambdaFunctionTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionTags(ResourceMapFilter ... lambdaFunctionTags) {
            this.lambdaFunctionTags(Arrays.asList(lambdaFunctionTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionTags(Consumer<ResourceMapFilter.Builder> ... lambdaFunctionTags) {
            this.lambdaFunctionTags(Stream.of(lambdaFunctionTags).map(c -> (ResourceMapFilter)((ResourceMapFilter.Builder)ResourceMapFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceStringFilter.Builder> getResourceId() {
            List<ResourceStringFilter.Builder> result = ResourceStringFilterListCopier.copyToBuilder(this.resourceId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceId(Collection<ResourceStringFilter.BuilderImpl> resourceId) {
            this.resourceId = ResourceStringFilterListCopier.copyFromBuilder(resourceId);
        }

        @Override
        public final Builder resourceId(Collection<ResourceStringFilter> resourceId) {
            this.resourceId = ResourceStringFilterListCopier.copy(resourceId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(ResourceStringFilter ... resourceId) {
            this.resourceId(Arrays.asList(resourceId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(Consumer<ResourceStringFilter.Builder> ... resourceId) {
            this.resourceId(Stream.of(resourceId).map(c -> (ResourceStringFilter)((ResourceStringFilter.Builder)ResourceStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceStringFilter.Builder> getResourceType() {
            List<ResourceStringFilter.Builder> result = ResourceStringFilterListCopier.copyToBuilder(this.resourceType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceType(Collection<ResourceStringFilter.BuilderImpl> resourceType) {
            this.resourceType = ResourceStringFilterListCopier.copyFromBuilder(resourceType);
        }

        @Override
        public final Builder resourceType(Collection<ResourceStringFilter> resourceType) {
            this.resourceType = ResourceStringFilterListCopier.copy(resourceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(ResourceStringFilter ... resourceType) {
            this.resourceType(Arrays.asList(resourceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(Consumer<ResourceStringFilter.Builder> ... resourceType) {
            this.resourceType(Stream.of(resourceType).map(c -> (ResourceStringFilter)((ResourceStringFilter.Builder)ResourceStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResourceFilterCriteria build() {
            return new ResourceFilterCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceFilterCriteria> {
        public Builder accountId(Collection<ResourceStringFilter> var1);

        public Builder accountId(ResourceStringFilter ... var1);

        public Builder accountId(Consumer<ResourceStringFilter.Builder> ... var1);

        public Builder ec2InstanceTags(Collection<ResourceMapFilter> var1);

        public Builder ec2InstanceTags(ResourceMapFilter ... var1);

        public Builder ec2InstanceTags(Consumer<ResourceMapFilter.Builder> ... var1);

        public Builder ecrImageTags(Collection<ResourceStringFilter> var1);

        public Builder ecrImageTags(ResourceStringFilter ... var1);

        public Builder ecrImageTags(Consumer<ResourceStringFilter.Builder> ... var1);

        public Builder ecrRepositoryName(Collection<ResourceStringFilter> var1);

        public Builder ecrRepositoryName(ResourceStringFilter ... var1);

        public Builder ecrRepositoryName(Consumer<ResourceStringFilter.Builder> ... var1);

        public Builder lambdaFunctionName(Collection<ResourceStringFilter> var1);

        public Builder lambdaFunctionName(ResourceStringFilter ... var1);

        public Builder lambdaFunctionName(Consumer<ResourceStringFilter.Builder> ... var1);

        public Builder lambdaFunctionTags(Collection<ResourceMapFilter> var1);

        public Builder lambdaFunctionTags(ResourceMapFilter ... var1);

        public Builder lambdaFunctionTags(Consumer<ResourceMapFilter.Builder> ... var1);

        public Builder resourceId(Collection<ResourceStringFilter> var1);

        public Builder resourceId(ResourceStringFilter ... var1);

        public Builder resourceId(Consumer<ResourceStringFilter.Builder> ... var1);

        public Builder resourceType(Collection<ResourceStringFilter> var1);

        public Builder resourceType(ResourceStringFilter ... var1);

        public Builder resourceType(Consumer<ResourceStringFilter.Builder> ... var1);
    }
}

