/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.LambdaLayerSortBy;
import software.amazon.awssdk.services.inspector2.model.SortOrder;
import software.amazon.awssdk.services.inspector2.model.StringFilter;
import software.amazon.awssdk.services.inspector2.model.StringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaLayerAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaLayerAggregation> {
    private static final SdkField<List<StringFilter>> FUNCTION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("functionNames").getter(LambdaLayerAggregation.getter(LambdaLayerAggregation::functionNames)).setter(LambdaLayerAggregation.setter(Builder::functionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> LAYER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("layerArns").getter(LambdaLayerAggregation.getter(LambdaLayerAggregation::layerArns)).setter(LambdaLayerAggregation.setter(Builder::layerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringFilter>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceIds").getter(LambdaLayerAggregation.getter(LambdaLayerAggregation::resourceIds)).setter(LambdaLayerAggregation.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(LambdaLayerAggregation.getter(LambdaLayerAggregation::sortByAsString)).setter(LambdaLayerAggregation.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(LambdaLayerAggregation.getter(LambdaLayerAggregation::sortOrderAsString)).setter(LambdaLayerAggregation.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAMES_FIELD, LAYER_ARNS_FIELD, RESOURCE_IDS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LambdaLayerAggregation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StringFilter> functionNames;
    private final List<StringFilter> layerArns;
    private final List<StringFilter> resourceIds;
    private final String sortBy;
    private final String sortOrder;

    private LambdaLayerAggregation(BuilderImpl builder) {
        this.functionNames = builder.functionNames;
        this.layerArns = builder.layerArns;
        this.resourceIds = builder.resourceIds;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final boolean hasFunctionNames() {
        return this.functionNames != null && !(this.functionNames instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> functionNames() {
        return this.functionNames;
    }

    public final boolean hasLayerArns() {
        return this.layerArns != null && !(this.layerArns instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> layerArns() {
        return this.layerArns;
    }

    public final boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public final List<StringFilter> resourceIds() {
        return this.resourceIds;
    }

    public final LambdaLayerSortBy sortBy() {
        return LambdaLayerSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionNames() ? this.functionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayerArns() ? this.layerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIds() ? this.resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaLayerAggregation)) {
            return false;
        }
        LambdaLayerAggregation other = (LambdaLayerAggregation)obj;
        return this.hasFunctionNames() == other.hasFunctionNames() && Objects.equals(this.functionNames(), other.functionNames()) && this.hasLayerArns() == other.hasLayerArns() && Objects.equals(this.layerArns(), other.layerArns()) && this.hasResourceIds() == other.hasResourceIds() && Objects.equals(this.resourceIds(), other.resourceIds()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaLayerAggregation").add("FunctionNames", this.hasFunctionNames() ? this.functionNames() : null).add("LayerArns", this.hasLayerArns() ? this.layerArns() : null).add("ResourceIds", this.hasResourceIds() ? this.resourceIds() : null).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functionNames": {
                return Optional.ofNullable(clazz.cast(this.functionNames()));
            }
            case "layerArns": {
                return Optional.ofNullable(clazz.cast(this.layerArns()));
            }
            case "resourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("functionNames", FUNCTION_NAMES_FIELD);
        map.put("layerArns", LAYER_ARNS_FIELD);
        map.put("resourceIds", RESOURCE_IDS_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaLayerAggregation, T> g) {
        return obj -> g.apply((LambdaLayerAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StringFilter> functionNames = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> layerArns = DefaultSdkAutoConstructList.getInstance();
        private List<StringFilter> resourceIds = DefaultSdkAutoConstructList.getInstance();
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaLayerAggregation model) {
            this.functionNames(model.functionNames);
            this.layerArns(model.layerArns);
            this.resourceIds(model.resourceIds);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final List<StringFilter.Builder> getFunctionNames() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.functionNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctionNames(Collection<StringFilter.BuilderImpl> functionNames) {
            this.functionNames = StringFilterListCopier.copyFromBuilder(functionNames);
        }

        @Override
        public final Builder functionNames(Collection<StringFilter> functionNames) {
            this.functionNames = StringFilterListCopier.copy(functionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionNames(StringFilter ... functionNames) {
            this.functionNames(Arrays.asList(functionNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionNames(Consumer<StringFilter.Builder> ... functionNames) {
            this.functionNames(Stream.of(functionNames).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getLayerArns() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.layerArns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayerArns(Collection<StringFilter.BuilderImpl> layerArns) {
            this.layerArns = StringFilterListCopier.copyFromBuilder(layerArns);
        }

        @Override
        public final Builder layerArns(Collection<StringFilter> layerArns) {
            this.layerArns = StringFilterListCopier.copy(layerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerArns(StringFilter ... layerArns) {
            this.layerArns(Arrays.asList(layerArns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerArns(Consumer<StringFilter.Builder> ... layerArns) {
            this.layerArns(Stream.of(layerArns).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIds(Collection<StringFilter.BuilderImpl> resourceIds) {
            this.resourceIds = StringFilterListCopier.copyFromBuilder(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<StringFilter> resourceIds) {
            this.resourceIds = StringFilterListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(StringFilter ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(Consumer<StringFilter.Builder> ... resourceIds) {
            this.resourceIds(Stream.of(resourceIds).map(c -> (StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(LambdaLayerSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public LambdaLayerAggregation build() {
            return new LambdaLayerAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaLayerAggregation> {
        public Builder functionNames(Collection<StringFilter> var1);

        public Builder functionNames(StringFilter ... var1);

        public Builder functionNames(Consumer<StringFilter.Builder> ... var1);

        public Builder layerArns(Collection<StringFilter> var1);

        public Builder layerArns(StringFilter ... var1);

        public Builder layerArns(Consumer<StringFilter.Builder> ... var1);

        public Builder resourceIds(Collection<StringFilter> var1);

        public Builder resourceIds(StringFilter ... var1);

        public Builder resourceIds(Consumer<StringFilter.Builder> ... var1);

        public Builder sortBy(String var1);

        public Builder sortBy(LambdaLayerSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);
    }
}

