/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.Destination;
import software.amazon.awssdk.services.inspector2.model.ExternalReportStatus;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.services.inspector2.model.ReportingErrorCode;
import software.amazon.awssdk.services.inspector2.model.ResourceFilterCriteria;
import software.amazon.awssdk.services.inspector2.model.SbomReportFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSbomExportResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, GetSbomExportResponse> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(GetSbomExportResponse.getter(GetSbomExportResponse::errorCodeAsString)).setter(GetSbomExportResponse.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(GetSbomExportResponse.getter(GetSbomExportResponse::errorMessage)).setter(GetSbomExportResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<ResourceFilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterCriteria").getter(GetSbomExportResponse.getter(GetSbomExportResponse::filterCriteria)).setter(GetSbomExportResponse.setter(Builder::filterCriteria)).constructor(ResourceFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(GetSbomExportResponse.getter(GetSbomExportResponse::formatAsString)).setter(GetSbomExportResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportId").getter(GetSbomExportResponse.getter(GetSbomExportResponse::reportId)).setter(GetSbomExportResponse.setter(Builder::reportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportId").build()}).build();
    private static final SdkField<Destination> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Destination").getter(GetSbomExportResponse.getter(GetSbomExportResponse::s3Destination)).setter(GetSbomExportResponse.setter(Builder::s3Destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetSbomExportResponse.getter(GetSbomExportResponse::statusAsString)).setter(GetSbomExportResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, FILTER_CRITERIA_FIELD, FORMAT_FIELD, REPORT_ID_FIELD, S3_DESTINATION_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSbomExportResponse.memberNameToFieldInitializer();
    private final String errorCode;
    private final String errorMessage;
    private final ResourceFilterCriteria filterCriteria;
    private final String format;
    private final String reportId;
    private final Destination s3Destination;
    private final String status;

    private GetSbomExportResponse(BuilderImpl builder) {
        super(builder);
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.filterCriteria = builder.filterCriteria;
        this.format = builder.format;
        this.reportId = builder.reportId;
        this.s3Destination = builder.s3Destination;
        this.status = builder.status;
    }

    public final ReportingErrorCode errorCode() {
        return ReportingErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final ResourceFilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final SbomReportFormat format() {
        return SbomReportFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String reportId() {
        return this.reportId;
    }

    public final Destination s3Destination() {
        return this.s3Destination;
    }

    public final ExternalReportStatus status() {
        return ExternalReportStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSbomExportResponse)) {
            return false;
        }
        GetSbomExportResponse other = (GetSbomExportResponse)((Object)obj);
        return Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.reportId(), other.reportId()) && Objects.equals(this.s3Destination(), other.s3Destination()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetSbomExportResponse").add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("FilterCriteria", (Object)this.filterCriteria()).add("Format", (Object)this.formatAsString()).add("ReportId", (Object)this.reportId()).add("S3Destination", (Object)this.s3Destination()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "filterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "reportId": {
                return Optional.ofNullable(clazz.cast(this.reportId()));
            }
            case "s3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("filterCriteria", FILTER_CRITERIA_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("reportId", REPORT_ID_FIELD);
        map.put("s3Destination", S3_DESTINATION_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSbomExportResponse, T> g) {
        return obj -> g.apply((GetSbomExportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private String errorCode;
        private String errorMessage;
        private ResourceFilterCriteria filterCriteria;
        private String format;
        private String reportId;
        private Destination s3Destination;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSbomExportResponse model) {
            super(model);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.filterCriteria(model.filterCriteria);
            this.format(model.format);
            this.reportId(model.reportId);
            this.s3Destination(model.s3Destination);
            this.status(model.status);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ReportingErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final ResourceFilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(ResourceFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(ResourceFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(SbomReportFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExternalReportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetSbomExportResponse build() {
            return new GetSbomExportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSbomExportResponse> {
        public Builder errorCode(String var1);

        public Builder errorCode(ReportingErrorCode var1);

        public Builder errorMessage(String var1);

        public Builder filterCriteria(ResourceFilterCriteria var1);

        default public Builder filterCriteria(Consumer<ResourceFilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((ResourceFilterCriteria)((ResourceFilterCriteria.Builder)ResourceFilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder format(String var1);

        public Builder format(SbomReportFormat var1);

        public Builder reportId(String var1);

        public Builder s3Destination(Destination var1);

        default public Builder s3Destination(Consumer<Destination.Builder> s3Destination) {
            return this.s3Destination((Destination)((Destination.Builder)Destination.builder().applyMutation(s3Destination)).build());
        }

        public Builder status(String var1);

        public Builder status(ExternalReportStatus var1);
    }
}

