/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.SeverityCounts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountAggregationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountAggregationResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(AccountAggregationResponse.getter(AccountAggregationResponse::accountId)).setter(AccountAggregationResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Long> EXPLOIT_AVAILABLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("exploitAvailableCount").getter(AccountAggregationResponse.getter(AccountAggregationResponse::exploitAvailableCount)).setter(AccountAggregationResponse.setter(Builder::exploitAvailableCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exploitAvailableCount").build()}).build();
    private static final SdkField<Long> FIX_AVAILABLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("fixAvailableCount").getter(AccountAggregationResponse.getter(AccountAggregationResponse::fixAvailableCount)).setter(AccountAggregationResponse.setter(Builder::fixAvailableCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixAvailableCount").build()}).build();
    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("severityCounts").getter(AccountAggregationResponse.getter(AccountAggregationResponse::severityCounts)).setter(AccountAggregationResponse.setter(Builder::severityCounts)).constructor(SeverityCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, EXPLOIT_AVAILABLE_COUNT_FIELD, FIX_AVAILABLE_COUNT_FIELD, SEVERITY_COUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountAggregationResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final Long exploitAvailableCount;
    private final Long fixAvailableCount;
    private final SeverityCounts severityCounts;

    private AccountAggregationResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.exploitAvailableCount = builder.exploitAvailableCount;
        this.fixAvailableCount = builder.fixAvailableCount;
        this.severityCounts = builder.severityCounts;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Long exploitAvailableCount() {
        return this.exploitAvailableCount;
    }

    public final Long fixAvailableCount() {
        return this.fixAvailableCount;
    }

    public final SeverityCounts severityCounts() {
        return this.severityCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exploitAvailableCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixAvailableCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityCounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAggregationResponse)) {
            return false;
        }
        AccountAggregationResponse other = (AccountAggregationResponse)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.exploitAvailableCount(), other.exploitAvailableCount()) && Objects.equals(this.fixAvailableCount(), other.fixAvailableCount()) && Objects.equals(this.severityCounts(), other.severityCounts());
    }

    public final String toString() {
        return ToString.builder((String)"AccountAggregationResponse").add("AccountId", (Object)this.accountId()).add("ExploitAvailableCount", (Object)this.exploitAvailableCount()).add("FixAvailableCount", (Object)this.fixAvailableCount()).add("SeverityCounts", (Object)this.severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "exploitAvailableCount": {
                return Optional.ofNullable(clazz.cast(this.exploitAvailableCount()));
            }
            case "fixAvailableCount": {
                return Optional.ofNullable(clazz.cast(this.fixAvailableCount()));
            }
            case "severityCounts": {
                return Optional.ofNullable(clazz.cast(this.severityCounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("exploitAvailableCount", EXPLOIT_AVAILABLE_COUNT_FIELD);
        map.put("fixAvailableCount", FIX_AVAILABLE_COUNT_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountAggregationResponse, T> g) {
        return obj -> g.apply((AccountAggregationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Long exploitAvailableCount;
        private Long fixAvailableCount;
        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAggregationResponse model) {
            this.accountId(model.accountId);
            this.exploitAvailableCount(model.exploitAvailableCount);
            this.fixAvailableCount(model.fixAvailableCount);
            this.severityCounts(model.severityCounts);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Long getExploitAvailableCount() {
            return this.exploitAvailableCount;
        }

        public final void setExploitAvailableCount(Long exploitAvailableCount) {
            this.exploitAvailableCount = exploitAvailableCount;
        }

        @Override
        public final Builder exploitAvailableCount(Long exploitAvailableCount) {
            this.exploitAvailableCount = exploitAvailableCount;
            return this;
        }

        public final Long getFixAvailableCount() {
            return this.fixAvailableCount;
        }

        public final void setFixAvailableCount(Long fixAvailableCount) {
            this.fixAvailableCount = fixAvailableCount;
        }

        @Override
        public final Builder fixAvailableCount(Long fixAvailableCount) {
            this.fixAvailableCount = fixAvailableCount;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return this.severityCounts != null ? this.severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public AccountAggregationResponse build() {
            return new AccountAggregationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountAggregationResponse> {
        public Builder accountId(String var1);

        public Builder exploitAvailableCount(Long var1);

        public Builder fixAvailableCount(Long var1);

        public Builder severityCounts(SeverityCounts var1);

        default public Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return this.severityCounts((SeverityCounts)((SeverityCounts.Builder)SeverityCounts.builder().applyMutation(severityCounts)).build());
        }
    }
}

