/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.AccountIdFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisDateFilter;
import software.amazon.awssdk.services.inspector2.model.CisNumberFilter;
import software.amazon.awssdk.services.inspector2.model.CisNumberFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisScanArnFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisScanConfigurationArnFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisScanDateFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisScanNameFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisScanStatusFilter;
import software.amazon.awssdk.services.inspector2.model.CisScanStatusFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisScheduledByFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisStringFilter;
import software.amazon.awssdk.services.inspector2.model.ResourceIdFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.ResourceTagFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.TagFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCisScansFilterCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListCisScansFilterCriteria> {
    private static final SdkField<List<CisNumberFilter>> FAILED_CHECKS_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedChecksFilters").getter(ListCisScansFilterCriteria.getter(ListCisScansFilterCriteria::failedChecksFilters)).setter(ListCisScansFilterCriteria.setter(Builder::failedChecksFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedChecksFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisNumberFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> SCAN_ARN_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanArnFilters").getter(ListCisScansFilterCriteria.getter(ListCisScansFilterCriteria::scanArnFilters)).setter(ListCisScansFilterCriteria.setter(Builder::scanArnFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArnFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisDateFilter>> SCAN_AT_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanAtFilters").getter(ListCisScansFilterCriteria.getter(ListCisScansFilterCriteria::scanAtFilters)).setter(ListCisScansFilterCriteria.setter(Builder::scanAtFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanAtFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisDateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> SCAN_CONFIGURATION_ARN_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanConfigurationArnFilters").getter(ListCisScansFilterCriteria.getter(ListCisScansFilterCriteria::scanConfigurationArnFilters)).setter(ListCisScansFilterCriteria.setter(Builder::scanConfigurationArnFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArnFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> SCAN_NAME_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanNameFilters").getter(ListCisScansFilterCriteria.getter(ListCisScansFilterCriteria::scanNameFilters)).setter(ListCisScansFilterCriteria.setter(Builder::scanNameFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanNameFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisScanStatusFilter>> SCAN_STATUS_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanStatusFilters").getter(ListCisScansFilterCriteria.getter(ListCisScansFilterCriteria::scanStatusFilters)).setter(ListCisScansFilterCriteria.setter(Builder::scanStatusFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatusFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisScanStatusFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> SCHEDULED_BY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scheduledByFilters").getter(ListCisScansFilterCriteria.getter(ListCisScansFilterCriteria::scheduledByFilters)).setter(ListCisScansFilterCriteria.setter(Builder::scheduledByFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledByFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> TARGET_ACCOUNT_ID_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetAccountIdFilters").getter(ListCisScansFilterCriteria.getter(ListCisScansFilterCriteria::targetAccountIdFilters)).setter(ListCisScansFilterCriteria.setter(Builder::targetAccountIdFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountIdFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> TARGET_RESOURCE_ID_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetResourceIdFilters").getter(ListCisScansFilterCriteria.getter(ListCisScansFilterCriteria::targetResourceIdFilters)).setter(ListCisScansFilterCriteria.setter(Builder::targetResourceIdFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceIdFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagFilter>> TARGET_RESOURCE_TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetResourceTagFilters").getter(ListCisScansFilterCriteria.getter(ListCisScansFilterCriteria::targetResourceTagFilters)).setter(ListCisScansFilterCriteria.setter(Builder::targetResourceTagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceTagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_CHECKS_FILTERS_FIELD, SCAN_ARN_FILTERS_FIELD, SCAN_AT_FILTERS_FIELD, SCAN_CONFIGURATION_ARN_FILTERS_FIELD, SCAN_NAME_FILTERS_FIELD, SCAN_STATUS_FILTERS_FIELD, SCHEDULED_BY_FILTERS_FIELD, TARGET_ACCOUNT_ID_FILTERS_FIELD, TARGET_RESOURCE_ID_FILTERS_FIELD, TARGET_RESOURCE_TAG_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCisScansFilterCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<CisNumberFilter> failedChecksFilters;
    private final List<CisStringFilter> scanArnFilters;
    private final List<CisDateFilter> scanAtFilters;
    private final List<CisStringFilter> scanConfigurationArnFilters;
    private final List<CisStringFilter> scanNameFilters;
    private final List<CisScanStatusFilter> scanStatusFilters;
    private final List<CisStringFilter> scheduledByFilters;
    private final List<CisStringFilter> targetAccountIdFilters;
    private final List<CisStringFilter> targetResourceIdFilters;
    private final List<TagFilter> targetResourceTagFilters;

    private ListCisScansFilterCriteria(BuilderImpl builder) {
        this.failedChecksFilters = builder.failedChecksFilters;
        this.scanArnFilters = builder.scanArnFilters;
        this.scanAtFilters = builder.scanAtFilters;
        this.scanConfigurationArnFilters = builder.scanConfigurationArnFilters;
        this.scanNameFilters = builder.scanNameFilters;
        this.scanStatusFilters = builder.scanStatusFilters;
        this.scheduledByFilters = builder.scheduledByFilters;
        this.targetAccountIdFilters = builder.targetAccountIdFilters;
        this.targetResourceIdFilters = builder.targetResourceIdFilters;
        this.targetResourceTagFilters = builder.targetResourceTagFilters;
    }

    public final boolean hasFailedChecksFilters() {
        return this.failedChecksFilters != null && !(this.failedChecksFilters instanceof SdkAutoConstructList);
    }

    public final List<CisNumberFilter> failedChecksFilters() {
        return this.failedChecksFilters;
    }

    public final boolean hasScanArnFilters() {
        return this.scanArnFilters != null && !(this.scanArnFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> scanArnFilters() {
        return this.scanArnFilters;
    }

    public final boolean hasScanAtFilters() {
        return this.scanAtFilters != null && !(this.scanAtFilters instanceof SdkAutoConstructList);
    }

    public final List<CisDateFilter> scanAtFilters() {
        return this.scanAtFilters;
    }

    public final boolean hasScanConfigurationArnFilters() {
        return this.scanConfigurationArnFilters != null && !(this.scanConfigurationArnFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> scanConfigurationArnFilters() {
        return this.scanConfigurationArnFilters;
    }

    public final boolean hasScanNameFilters() {
        return this.scanNameFilters != null && !(this.scanNameFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> scanNameFilters() {
        return this.scanNameFilters;
    }

    public final boolean hasScanStatusFilters() {
        return this.scanStatusFilters != null && !(this.scanStatusFilters instanceof SdkAutoConstructList);
    }

    public final List<CisScanStatusFilter> scanStatusFilters() {
        return this.scanStatusFilters;
    }

    public final boolean hasScheduledByFilters() {
        return this.scheduledByFilters != null && !(this.scheduledByFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> scheduledByFilters() {
        return this.scheduledByFilters;
    }

    public final boolean hasTargetAccountIdFilters() {
        return this.targetAccountIdFilters != null && !(this.targetAccountIdFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> targetAccountIdFilters() {
        return this.targetAccountIdFilters;
    }

    public final boolean hasTargetResourceIdFilters() {
        return this.targetResourceIdFilters != null && !(this.targetResourceIdFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> targetResourceIdFilters() {
        return this.targetResourceIdFilters;
    }

    public final boolean hasTargetResourceTagFilters() {
        return this.targetResourceTagFilters != null && !(this.targetResourceTagFilters instanceof SdkAutoConstructList);
    }

    public final List<TagFilter> targetResourceTagFilters() {
        return this.targetResourceTagFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedChecksFilters() ? this.failedChecksFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanArnFilters() ? this.scanArnFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanAtFilters() ? this.scanAtFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanConfigurationArnFilters() ? this.scanConfigurationArnFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanNameFilters() ? this.scanNameFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanStatusFilters() ? this.scanStatusFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledByFilters() ? this.scheduledByFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetAccountIdFilters() ? this.targetAccountIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetResourceIdFilters() ? this.targetResourceIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetResourceTagFilters() ? this.targetResourceTagFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCisScansFilterCriteria)) {
            return false;
        }
        ListCisScansFilterCriteria other = (ListCisScansFilterCriteria)obj;
        return this.hasFailedChecksFilters() == other.hasFailedChecksFilters() && Objects.equals(this.failedChecksFilters(), other.failedChecksFilters()) && this.hasScanArnFilters() == other.hasScanArnFilters() && Objects.equals(this.scanArnFilters(), other.scanArnFilters()) && this.hasScanAtFilters() == other.hasScanAtFilters() && Objects.equals(this.scanAtFilters(), other.scanAtFilters()) && this.hasScanConfigurationArnFilters() == other.hasScanConfigurationArnFilters() && Objects.equals(this.scanConfigurationArnFilters(), other.scanConfigurationArnFilters()) && this.hasScanNameFilters() == other.hasScanNameFilters() && Objects.equals(this.scanNameFilters(), other.scanNameFilters()) && this.hasScanStatusFilters() == other.hasScanStatusFilters() && Objects.equals(this.scanStatusFilters(), other.scanStatusFilters()) && this.hasScheduledByFilters() == other.hasScheduledByFilters() && Objects.equals(this.scheduledByFilters(), other.scheduledByFilters()) && this.hasTargetAccountIdFilters() == other.hasTargetAccountIdFilters() && Objects.equals(this.targetAccountIdFilters(), other.targetAccountIdFilters()) && this.hasTargetResourceIdFilters() == other.hasTargetResourceIdFilters() && Objects.equals(this.targetResourceIdFilters(), other.targetResourceIdFilters()) && this.hasTargetResourceTagFilters() == other.hasTargetResourceTagFilters() && Objects.equals(this.targetResourceTagFilters(), other.targetResourceTagFilters());
    }

    public final String toString() {
        return ToString.builder((String)"ListCisScansFilterCriteria").add("FailedChecksFilters", this.hasFailedChecksFilters() ? this.failedChecksFilters() : null).add("ScanArnFilters", this.hasScanArnFilters() ? this.scanArnFilters() : null).add("ScanAtFilters", this.hasScanAtFilters() ? this.scanAtFilters() : null).add("ScanConfigurationArnFilters", this.hasScanConfigurationArnFilters() ? this.scanConfigurationArnFilters() : null).add("ScanNameFilters", this.hasScanNameFilters() ? this.scanNameFilters() : null).add("ScanStatusFilters", this.hasScanStatusFilters() ? this.scanStatusFilters() : null).add("ScheduledByFilters", this.hasScheduledByFilters() ? this.scheduledByFilters() : null).add("TargetAccountIdFilters", this.hasTargetAccountIdFilters() ? this.targetAccountIdFilters() : null).add("TargetResourceIdFilters", this.hasTargetResourceIdFilters() ? this.targetResourceIdFilters() : null).add("TargetResourceTagFilters", this.hasTargetResourceTagFilters() ? this.targetResourceTagFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failedChecksFilters": {
                return Optional.ofNullable(clazz.cast(this.failedChecksFilters()));
            }
            case "scanArnFilters": {
                return Optional.ofNullable(clazz.cast(this.scanArnFilters()));
            }
            case "scanAtFilters": {
                return Optional.ofNullable(clazz.cast(this.scanAtFilters()));
            }
            case "scanConfigurationArnFilters": {
                return Optional.ofNullable(clazz.cast(this.scanConfigurationArnFilters()));
            }
            case "scanNameFilters": {
                return Optional.ofNullable(clazz.cast(this.scanNameFilters()));
            }
            case "scanStatusFilters": {
                return Optional.ofNullable(clazz.cast(this.scanStatusFilters()));
            }
            case "scheduledByFilters": {
                return Optional.ofNullable(clazz.cast(this.scheduledByFilters()));
            }
            case "targetAccountIdFilters": {
                return Optional.ofNullable(clazz.cast(this.targetAccountIdFilters()));
            }
            case "targetResourceIdFilters": {
                return Optional.ofNullable(clazz.cast(this.targetResourceIdFilters()));
            }
            case "targetResourceTagFilters": {
                return Optional.ofNullable(clazz.cast(this.targetResourceTagFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("failedChecksFilters", FAILED_CHECKS_FILTERS_FIELD);
        map.put("scanArnFilters", SCAN_ARN_FILTERS_FIELD);
        map.put("scanAtFilters", SCAN_AT_FILTERS_FIELD);
        map.put("scanConfigurationArnFilters", SCAN_CONFIGURATION_ARN_FILTERS_FIELD);
        map.put("scanNameFilters", SCAN_NAME_FILTERS_FIELD);
        map.put("scanStatusFilters", SCAN_STATUS_FILTERS_FIELD);
        map.put("scheduledByFilters", SCHEDULED_BY_FILTERS_FIELD);
        map.put("targetAccountIdFilters", TARGET_ACCOUNT_ID_FILTERS_FIELD);
        map.put("targetResourceIdFilters", TARGET_RESOURCE_ID_FILTERS_FIELD);
        map.put("targetResourceTagFilters", TARGET_RESOURCE_TAG_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCisScansFilterCriteria, T> g) {
        return obj -> g.apply((ListCisScansFilterCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CisNumberFilter> failedChecksFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> scanArnFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisDateFilter> scanAtFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> scanConfigurationArnFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> scanNameFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisScanStatusFilter> scanStatusFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> scheduledByFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> targetAccountIdFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> targetResourceIdFilters = DefaultSdkAutoConstructList.getInstance();
        private List<TagFilter> targetResourceTagFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCisScansFilterCriteria model) {
            this.failedChecksFilters(model.failedChecksFilters);
            this.scanArnFilters(model.scanArnFilters);
            this.scanAtFilters(model.scanAtFilters);
            this.scanConfigurationArnFilters(model.scanConfigurationArnFilters);
            this.scanNameFilters(model.scanNameFilters);
            this.scanStatusFilters(model.scanStatusFilters);
            this.scheduledByFilters(model.scheduledByFilters);
            this.targetAccountIdFilters(model.targetAccountIdFilters);
            this.targetResourceIdFilters(model.targetResourceIdFilters);
            this.targetResourceTagFilters(model.targetResourceTagFilters);
        }

        public final List<CisNumberFilter.Builder> getFailedChecksFilters() {
            List<CisNumberFilter.Builder> result = CisNumberFilterListCopier.copyToBuilder(this.failedChecksFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedChecksFilters(Collection<CisNumberFilter.BuilderImpl> failedChecksFilters) {
            this.failedChecksFilters = CisNumberFilterListCopier.copyFromBuilder(failedChecksFilters);
        }

        @Override
        public final Builder failedChecksFilters(Collection<CisNumberFilter> failedChecksFilters) {
            this.failedChecksFilters = CisNumberFilterListCopier.copy(failedChecksFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedChecksFilters(CisNumberFilter ... failedChecksFilters) {
            this.failedChecksFilters(Arrays.asList(failedChecksFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedChecksFilters(Consumer<CisNumberFilter.Builder> ... failedChecksFilters) {
            this.failedChecksFilters(Stream.of(failedChecksFilters).map(c -> (CisNumberFilter)((CisNumberFilter.Builder)CisNumberFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getScanArnFilters() {
            List<CisStringFilter.Builder> result = CisScanArnFilterListCopier.copyToBuilder(this.scanArnFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanArnFilters(Collection<CisStringFilter.BuilderImpl> scanArnFilters) {
            this.scanArnFilters = CisScanArnFilterListCopier.copyFromBuilder(scanArnFilters);
        }

        @Override
        public final Builder scanArnFilters(Collection<CisStringFilter> scanArnFilters) {
            this.scanArnFilters = CisScanArnFilterListCopier.copy(scanArnFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanArnFilters(CisStringFilter ... scanArnFilters) {
            this.scanArnFilters(Arrays.asList(scanArnFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanArnFilters(Consumer<CisStringFilter.Builder> ... scanArnFilters) {
            this.scanArnFilters(Stream.of(scanArnFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisDateFilter.Builder> getScanAtFilters() {
            List<CisDateFilter.Builder> result = CisScanDateFilterListCopier.copyToBuilder(this.scanAtFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanAtFilters(Collection<CisDateFilter.BuilderImpl> scanAtFilters) {
            this.scanAtFilters = CisScanDateFilterListCopier.copyFromBuilder(scanAtFilters);
        }

        @Override
        public final Builder scanAtFilters(Collection<CisDateFilter> scanAtFilters) {
            this.scanAtFilters = CisScanDateFilterListCopier.copy(scanAtFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanAtFilters(CisDateFilter ... scanAtFilters) {
            this.scanAtFilters(Arrays.asList(scanAtFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanAtFilters(Consumer<CisDateFilter.Builder> ... scanAtFilters) {
            this.scanAtFilters(Stream.of(scanAtFilters).map(c -> (CisDateFilter)((CisDateFilter.Builder)CisDateFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getScanConfigurationArnFilters() {
            List<CisStringFilter.Builder> result = CisScanConfigurationArnFilterListCopier.copyToBuilder(this.scanConfigurationArnFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanConfigurationArnFilters(Collection<CisStringFilter.BuilderImpl> scanConfigurationArnFilters) {
            this.scanConfigurationArnFilters = CisScanConfigurationArnFilterListCopier.copyFromBuilder(scanConfigurationArnFilters);
        }

        @Override
        public final Builder scanConfigurationArnFilters(Collection<CisStringFilter> scanConfigurationArnFilters) {
            this.scanConfigurationArnFilters = CisScanConfigurationArnFilterListCopier.copy(scanConfigurationArnFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanConfigurationArnFilters(CisStringFilter ... scanConfigurationArnFilters) {
            this.scanConfigurationArnFilters(Arrays.asList(scanConfigurationArnFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanConfigurationArnFilters(Consumer<CisStringFilter.Builder> ... scanConfigurationArnFilters) {
            this.scanConfigurationArnFilters(Stream.of(scanConfigurationArnFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getScanNameFilters() {
            List<CisStringFilter.Builder> result = CisScanNameFilterListCopier.copyToBuilder(this.scanNameFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanNameFilters(Collection<CisStringFilter.BuilderImpl> scanNameFilters) {
            this.scanNameFilters = CisScanNameFilterListCopier.copyFromBuilder(scanNameFilters);
        }

        @Override
        public final Builder scanNameFilters(Collection<CisStringFilter> scanNameFilters) {
            this.scanNameFilters = CisScanNameFilterListCopier.copy(scanNameFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanNameFilters(CisStringFilter ... scanNameFilters) {
            this.scanNameFilters(Arrays.asList(scanNameFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanNameFilters(Consumer<CisStringFilter.Builder> ... scanNameFilters) {
            this.scanNameFilters(Stream.of(scanNameFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisScanStatusFilter.Builder> getScanStatusFilters() {
            List<CisScanStatusFilter.Builder> result = CisScanStatusFilterListCopier.copyToBuilder(this.scanStatusFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanStatusFilters(Collection<CisScanStatusFilter.BuilderImpl> scanStatusFilters) {
            this.scanStatusFilters = CisScanStatusFilterListCopier.copyFromBuilder(scanStatusFilters);
        }

        @Override
        public final Builder scanStatusFilters(Collection<CisScanStatusFilter> scanStatusFilters) {
            this.scanStatusFilters = CisScanStatusFilterListCopier.copy(scanStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanStatusFilters(CisScanStatusFilter ... scanStatusFilters) {
            this.scanStatusFilters(Arrays.asList(scanStatusFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanStatusFilters(Consumer<CisScanStatusFilter.Builder> ... scanStatusFilters) {
            this.scanStatusFilters(Stream.of(scanStatusFilters).map(c -> (CisScanStatusFilter)((CisScanStatusFilter.Builder)CisScanStatusFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getScheduledByFilters() {
            List<CisStringFilter.Builder> result = CisScheduledByFilterListCopier.copyToBuilder(this.scheduledByFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledByFilters(Collection<CisStringFilter.BuilderImpl> scheduledByFilters) {
            this.scheduledByFilters = CisScheduledByFilterListCopier.copyFromBuilder(scheduledByFilters);
        }

        @Override
        public final Builder scheduledByFilters(Collection<CisStringFilter> scheduledByFilters) {
            this.scheduledByFilters = CisScheduledByFilterListCopier.copy(scheduledByFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledByFilters(CisStringFilter ... scheduledByFilters) {
            this.scheduledByFilters(Arrays.asList(scheduledByFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledByFilters(Consumer<CisStringFilter.Builder> ... scheduledByFilters) {
            this.scheduledByFilters(Stream.of(scheduledByFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getTargetAccountIdFilters() {
            List<CisStringFilter.Builder> result = AccountIdFilterListCopier.copyToBuilder(this.targetAccountIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetAccountIdFilters(Collection<CisStringFilter.BuilderImpl> targetAccountIdFilters) {
            this.targetAccountIdFilters = AccountIdFilterListCopier.copyFromBuilder(targetAccountIdFilters);
        }

        @Override
        public final Builder targetAccountIdFilters(Collection<CisStringFilter> targetAccountIdFilters) {
            this.targetAccountIdFilters = AccountIdFilterListCopier.copy(targetAccountIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccountIdFilters(CisStringFilter ... targetAccountIdFilters) {
            this.targetAccountIdFilters(Arrays.asList(targetAccountIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccountIdFilters(Consumer<CisStringFilter.Builder> ... targetAccountIdFilters) {
            this.targetAccountIdFilters(Stream.of(targetAccountIdFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getTargetResourceIdFilters() {
            List<CisStringFilter.Builder> result = ResourceIdFilterListCopier.copyToBuilder(this.targetResourceIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceIdFilters(Collection<CisStringFilter.BuilderImpl> targetResourceIdFilters) {
            this.targetResourceIdFilters = ResourceIdFilterListCopier.copyFromBuilder(targetResourceIdFilters);
        }

        @Override
        public final Builder targetResourceIdFilters(Collection<CisStringFilter> targetResourceIdFilters) {
            this.targetResourceIdFilters = ResourceIdFilterListCopier.copy(targetResourceIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceIdFilters(CisStringFilter ... targetResourceIdFilters) {
            this.targetResourceIdFilters(Arrays.asList(targetResourceIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceIdFilters(Consumer<CisStringFilter.Builder> ... targetResourceIdFilters) {
            this.targetResourceIdFilters(Stream.of(targetResourceIdFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagFilter.Builder> getTargetResourceTagFilters() {
            List<TagFilter.Builder> result = ResourceTagFilterListCopier.copyToBuilder(this.targetResourceTagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceTagFilters(Collection<TagFilter.BuilderImpl> targetResourceTagFilters) {
            this.targetResourceTagFilters = ResourceTagFilterListCopier.copyFromBuilder(targetResourceTagFilters);
        }

        @Override
        public final Builder targetResourceTagFilters(Collection<TagFilter> targetResourceTagFilters) {
            this.targetResourceTagFilters = ResourceTagFilterListCopier.copy(targetResourceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTagFilters(TagFilter ... targetResourceTagFilters) {
            this.targetResourceTagFilters(Arrays.asList(targetResourceTagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTagFilters(Consumer<TagFilter.Builder> ... targetResourceTagFilters) {
            this.targetResourceTagFilters(Stream.of(targetResourceTagFilters).map(c -> (TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ListCisScansFilterCriteria build() {
            return new ListCisScansFilterCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListCisScansFilterCriteria> {
        public Builder failedChecksFilters(Collection<CisNumberFilter> var1);

        public Builder failedChecksFilters(CisNumberFilter ... var1);

        public Builder failedChecksFilters(Consumer<CisNumberFilter.Builder> ... var1);

        public Builder scanArnFilters(Collection<CisStringFilter> var1);

        public Builder scanArnFilters(CisStringFilter ... var1);

        public Builder scanArnFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder scanAtFilters(Collection<CisDateFilter> var1);

        public Builder scanAtFilters(CisDateFilter ... var1);

        public Builder scanAtFilters(Consumer<CisDateFilter.Builder> ... var1);

        public Builder scanConfigurationArnFilters(Collection<CisStringFilter> var1);

        public Builder scanConfigurationArnFilters(CisStringFilter ... var1);

        public Builder scanConfigurationArnFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder scanNameFilters(Collection<CisStringFilter> var1);

        public Builder scanNameFilters(CisStringFilter ... var1);

        public Builder scanNameFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder scanStatusFilters(Collection<CisScanStatusFilter> var1);

        public Builder scanStatusFilters(CisScanStatusFilter ... var1);

        public Builder scanStatusFilters(Consumer<CisScanStatusFilter.Builder> ... var1);

        public Builder scheduledByFilters(Collection<CisStringFilter> var1);

        public Builder scheduledByFilters(CisStringFilter ... var1);

        public Builder scheduledByFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder targetAccountIdFilters(Collection<CisStringFilter> var1);

        public Builder targetAccountIdFilters(CisStringFilter ... var1);

        public Builder targetAccountIdFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder targetResourceIdFilters(Collection<CisStringFilter> var1);

        public Builder targetResourceIdFilters(CisStringFilter ... var1);

        public Builder targetResourceIdFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder targetResourceTagFilters(Collection<TagFilter> var1);

        public Builder targetResourceTagFilters(TagFilter ... var1);

        public Builder targetResourceTagFilters(Consumer<TagFilter.Builder> ... var1);
    }
}

