/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CisReportFormat {
    PDF("PDF"),
    CSV("CSV"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CisReportFormat> VALUE_MAP;
    private final String value;

    private CisReportFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CisReportFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CisReportFormat> knownValues() {
        EnumSet<CisReportFormat> knownValues = EnumSet.allOf(CisReportFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CisReportFormat.class, CisReportFormat::toString);
    }
}

