/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorAsyncClient;
import software.amazon.awssdk.services.inspector.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector.model.ListExclusionsRequest;
import software.amazon.awssdk.services.inspector.model.ListExclusionsResponse;

public class ListExclusionsPublisher
implements SdkPublisher<ListExclusionsResponse> {
    private final InspectorAsyncClient client;
    private final ListExclusionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExclusionsPublisher(InspectorAsyncClient client, ListExclusionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExclusionsPublisher(InspectorAsyncClient client, ListExclusionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExclusionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExclusionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListExclusionsResponseFetcher
    implements AsyncPageFetcher<ListExclusionsResponse> {
        private ListExclusionsResponseFetcher() {
        }

        public boolean hasNextPage(ListExclusionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExclusionsResponse> nextPage(ListExclusionsResponse previousPage) {
            if (previousPage == null) {
                return ListExclusionsPublisher.this.client.listExclusions(ListExclusionsPublisher.this.firstRequest);
            }
            return ListExclusionsPublisher.this.client.listExclusions((ListExclusionsRequest)((Object)ListExclusionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

