/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorAsyncClient;
import software.amazon.awssdk.services.inspector.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse;

public class ListAssessmentTargetsPublisher
implements SdkPublisher<ListAssessmentTargetsResponse> {
    private final InspectorAsyncClient client;
    private final ListAssessmentTargetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssessmentTargetsPublisher(InspectorAsyncClient client, ListAssessmentTargetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssessmentTargetsPublisher(InspectorAsyncClient client, ListAssessmentTargetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssessmentTargetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssessmentTargetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAssessmentTargetsResponseFetcher
    implements AsyncPageFetcher<ListAssessmentTargetsResponse> {
        private ListAssessmentTargetsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssessmentTargetsResponse> nextPage(ListAssessmentTargetsResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentTargetsPublisher.this.client.listAssessmentTargets(ListAssessmentTargetsPublisher.this.firstRequest);
            }
            return ListAssessmentTargetsPublisher.this.client.listAssessmentTargets((ListAssessmentTargetsRequest)((Object)ListAssessmentTargetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

