/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.ExclusionPreview;
import software.amazon.awssdk.services.inspector.model.ExclusionPreviewListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.services.inspector.model.PreviewStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExclusionsPreviewResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, GetExclusionsPreviewResponse> {
    private static final SdkField<String> PREVIEW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("previewStatus").getter(GetExclusionsPreviewResponse.getter(GetExclusionsPreviewResponse::previewStatusAsString)).setter(GetExclusionsPreviewResponse.setter(Builder::previewStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previewStatus").build()}).build();
    private static final SdkField<List<ExclusionPreview>> EXCLUSION_PREVIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exclusionPreviews").getter(GetExclusionsPreviewResponse.getter(GetExclusionsPreviewResponse::exclusionPreviews)).setter(GetExclusionsPreviewResponse.setter(Builder::exclusionPreviews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionPreviews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExclusionPreview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetExclusionsPreviewResponse.getter(GetExclusionsPreviewResponse::nextToken)).setter(GetExclusionsPreviewResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREVIEW_STATUS_FIELD, EXCLUSION_PREVIEWS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetExclusionsPreviewResponse.memberNameToFieldInitializer();
    private final String previewStatus;
    private final List<ExclusionPreview> exclusionPreviews;
    private final String nextToken;

    private GetExclusionsPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.previewStatus = builder.previewStatus;
        this.exclusionPreviews = builder.exclusionPreviews;
        this.nextToken = builder.nextToken;
    }

    public final PreviewStatus previewStatus() {
        return PreviewStatus.fromValue(this.previewStatus);
    }

    public final String previewStatusAsString() {
        return this.previewStatus;
    }

    public final boolean hasExclusionPreviews() {
        return this.exclusionPreviews != null && !(this.exclusionPreviews instanceof SdkAutoConstructList);
    }

    public final List<ExclusionPreview> exclusionPreviews() {
        return this.exclusionPreviews;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.previewStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionPreviews() ? this.exclusionPreviews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExclusionsPreviewResponse)) {
            return false;
        }
        GetExclusionsPreviewResponse other = (GetExclusionsPreviewResponse)((Object)obj);
        return Objects.equals(this.previewStatusAsString(), other.previewStatusAsString()) && this.hasExclusionPreviews() == other.hasExclusionPreviews() && Objects.equals(this.exclusionPreviews(), other.exclusionPreviews()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetExclusionsPreviewResponse").add("PreviewStatus", (Object)this.previewStatusAsString()).add("ExclusionPreviews", this.hasExclusionPreviews() ? this.exclusionPreviews() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "previewStatus": {
                return Optional.ofNullable(clazz.cast(this.previewStatusAsString()));
            }
            case "exclusionPreviews": {
                return Optional.ofNullable(clazz.cast(this.exclusionPreviews()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("previewStatus", PREVIEW_STATUS_FIELD);
        map.put("exclusionPreviews", EXCLUSION_PREVIEWS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExclusionsPreviewResponse, T> g) {
        return obj -> g.apply((GetExclusionsPreviewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private String previewStatus;
        private List<ExclusionPreview> exclusionPreviews = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExclusionsPreviewResponse model) {
            super(model);
            this.previewStatus(model.previewStatus);
            this.exclusionPreviews(model.exclusionPreviews);
            this.nextToken(model.nextToken);
        }

        public final String getPreviewStatus() {
            return this.previewStatus;
        }

        public final void setPreviewStatus(String previewStatus) {
            this.previewStatus = previewStatus;
        }

        @Override
        public final Builder previewStatus(String previewStatus) {
            this.previewStatus = previewStatus;
            return this;
        }

        @Override
        public final Builder previewStatus(PreviewStatus previewStatus) {
            this.previewStatus(previewStatus == null ? null : previewStatus.toString());
            return this;
        }

        public final List<ExclusionPreview.Builder> getExclusionPreviews() {
            List<ExclusionPreview.Builder> result = ExclusionPreviewListCopier.copyToBuilder(this.exclusionPreviews);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExclusionPreviews(Collection<ExclusionPreview.BuilderImpl> exclusionPreviews) {
            this.exclusionPreviews = ExclusionPreviewListCopier.copyFromBuilder(exclusionPreviews);
        }

        @Override
        public final Builder exclusionPreviews(Collection<ExclusionPreview> exclusionPreviews) {
            this.exclusionPreviews = ExclusionPreviewListCopier.copy(exclusionPreviews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPreviews(ExclusionPreview ... exclusionPreviews) {
            this.exclusionPreviews(Arrays.asList(exclusionPreviews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPreviews(Consumer<ExclusionPreview.Builder> ... exclusionPreviews) {
            this.exclusionPreviews(Stream.of(exclusionPreviews).map(c -> (ExclusionPreview)((ExclusionPreview.Builder)ExclusionPreview.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetExclusionsPreviewResponse build() {
            return new GetExclusionsPreviewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExclusionsPreviewResponse> {
        public Builder previewStatus(String var1);

        public Builder previewStatus(PreviewStatus var1);

        public Builder exclusionPreviews(Collection<ExclusionPreview> var1);

        public Builder exclusionPreviews(ExclusionPreview ... var1);

        public Builder exclusionPreviews(Consumer<ExclusionPreview.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

