/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AgentHealth {
    HEALTHY("HEALTHY"),
    UNHEALTHY("UNHEALTHY"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AgentHealth> VALUE_MAP;
    private final String value;

    private AgentHealth(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AgentHealth fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AgentHealth> knownValues() {
        EnumSet<AgentHealth> knownValues = EnumSet.allOf(AgentHealth.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AgentHealth.class, AgentHealth::toString);
    }
}

