/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StopAction {
    START_EVALUATION("START_EVALUATION"),
    SKIP_EVALUATION("SKIP_EVALUATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StopAction> VALUE_MAP;
    private final String value;

    private StopAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StopAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StopAction> knownValues() {
        EnumSet<StopAction> knownValues = EnumSet.allOf(StopAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StopAction.class, StopAction::toString);
    }
}

