/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FailedItemErrorCode {
    INVALID_ARN("INVALID_ARN"),
    DUPLICATE_ARN("DUPLICATE_ARN"),
    ITEM_DOES_NOT_EXIST("ITEM_DOES_NOT_EXIST"),
    ACCESS_DENIED("ACCESS_DENIED"),
    LIMIT_EXCEEDED("LIMIT_EXCEEDED"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FailedItemErrorCode> VALUE_MAP;
    private final String value;

    private FailedItemErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailedItemErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailedItemErrorCode> knownValues() {
        EnumSet<FailedItemErrorCode> knownValues = EnumSet.allOf(FailedItemErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FailedItemErrorCode.class, FailedItemErrorCode::toString);
    }
}

