/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.imds;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class Ec2MetadataRetryPolicy
implements ToCopyableBuilder<Builder, Ec2MetadataRetryPolicy> {
    private static final int DEFAULT_RETRY_ATTEMPTS = 3;
    private final BackoffStrategy backoffStrategy;
    private final Integer numRetries;

    private Ec2MetadataRetryPolicy(BuilderImpl builder) {
        this.numRetries = (Integer)Validate.getOrDefault((Object)builder.numRetries, () -> 3);
        this.backoffStrategy = (BackoffStrategy)Validate.getOrDefault((Object)builder.backoffStrategy, () -> BackoffStrategy.defaultStrategy((RetryMode)RetryMode.STANDARD));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Ec2MetadataRetryPolicy ec2MetadataRetryPolicy = (Ec2MetadataRetryPolicy)obj;
        if (!Objects.equals(this.numRetries, ec2MetadataRetryPolicy.numRetries)) {
            return false;
        }
        return Objects.equals(this.backoffStrategy, ec2MetadataRetryPolicy.backoffStrategy);
    }

    public int hashCode() {
        int result = Math.max(this.numRetries, 0);
        result = 31 * result + (this.backoffStrategy != null ? this.backoffStrategy.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Ec2MetadataRetryPolicy{backoffStrategy=" + this.backoffStrategy.toString() + ", numRetries=" + this.numRetries + '}';
    }

    public int numRetries() {
        return this.numRetries;
    }

    public BackoffStrategy backoffStrategy() {
        return this.backoffStrategy;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Builder toBuilder() {
        return Ec2MetadataRetryPolicy.builder().numRetries(this.numRetries).backoffStrategy(this.backoffStrategy);
    }

    public static Ec2MetadataRetryPolicy none() {
        return (Ec2MetadataRetryPolicy)Ec2MetadataRetryPolicy.builder().numRetries(0).build();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer numRetries;
        private BackoffStrategy backoffStrategy;

        private BuilderImpl() {
        }

        @Override
        public Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        @Override
        public Builder backoffStrategy(BackoffStrategy backoffStrategy) {
            this.backoffStrategy = backoffStrategy;
            return this;
        }

        public Ec2MetadataRetryPolicy build() {
            return new Ec2MetadataRetryPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Ec2MetadataRetryPolicy> {
        public Builder backoffStrategy(BackoffStrategy var1);

        public Builder numRetries(Integer var1);
    }
}

