/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TenancyType {
    DEFAULT("default"),
    DEDICATED("dedicated"),
    HOST("host"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TenancyType> VALUE_MAP;
    private final String value;

    private TenancyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TenancyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TenancyType> knownValues() {
        EnumSet<TenancyType> knownValues = EnumSet.allOf(TenancyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TenancyType.class, TenancyType::toString);
    }
}

