/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.AutoDisablePolicy;
import software.amazon.awssdk.services.imagebuilder.model.PipelineExecutionStartCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Schedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Schedule> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduleExpression").getter(Schedule.getter(Schedule::scheduleExpression)).setter(Schedule.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleExpression").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timezone").getter(Schedule.getter(Schedule::timezone)).setter(Schedule.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_START_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineExecutionStartCondition").getter(Schedule.getter(Schedule::pipelineExecutionStartConditionAsString)).setter(Schedule.setter(Builder::pipelineExecutionStartCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionStartCondition").build()}).build();
    private static final SdkField<AutoDisablePolicy> AUTO_DISABLE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoDisablePolicy").getter(Schedule.getter(Schedule::autoDisablePolicy)).setter(Schedule.setter(Builder::autoDisablePolicy)).constructor(AutoDisablePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoDisablePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD, TIMEZONE_FIELD, PIPELINE_EXECUTION_START_CONDITION_FIELD, AUTO_DISABLE_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Schedule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scheduleExpression;
    private final String timezone;
    private final String pipelineExecutionStartCondition;
    private final AutoDisablePolicy autoDisablePolicy;

    private Schedule(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.timezone = builder.timezone;
        this.pipelineExecutionStartCondition = builder.pipelineExecutionStartCondition;
        this.autoDisablePolicy = builder.autoDisablePolicy;
    }

    public final String scheduleExpression() {
        return this.scheduleExpression;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final PipelineExecutionStartCondition pipelineExecutionStartCondition() {
        return PipelineExecutionStartCondition.fromValue(this.pipelineExecutionStartCondition);
    }

    public final String pipelineExecutionStartConditionAsString() {
        return this.pipelineExecutionStartCondition;
    }

    public final AutoDisablePolicy autoDisablePolicy() {
        return this.autoDisablePolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionStartConditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoDisablePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)obj;
        return Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.pipelineExecutionStartConditionAsString(), other.pipelineExecutionStartConditionAsString()) && Objects.equals(this.autoDisablePolicy(), other.autoDisablePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"Schedule").add("ScheduleExpression", (Object)this.scheduleExpression()).add("Timezone", (Object)this.timezone()).add("PipelineExecutionStartCondition", (Object)this.pipelineExecutionStartConditionAsString()).add("AutoDisablePolicy", (Object)this.autoDisablePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "pipelineExecutionStartCondition": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionStartConditionAsString()));
            }
            case "autoDisablePolicy": {
                return Optional.ofNullable(clazz.cast(this.autoDisablePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("timezone", TIMEZONE_FIELD);
        map.put("pipelineExecutionStartCondition", PIPELINE_EXECUTION_START_CONDITION_FIELD);
        map.put("autoDisablePolicy", AUTO_DISABLE_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scheduleExpression;
        private String timezone;
        private String pipelineExecutionStartCondition;
        private AutoDisablePolicy autoDisablePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            this.scheduleExpression(model.scheduleExpression);
            this.timezone(model.timezone);
            this.pipelineExecutionStartCondition(model.pipelineExecutionStartCondition);
            this.autoDisablePolicy(model.autoDisablePolicy);
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getPipelineExecutionStartCondition() {
            return this.pipelineExecutionStartCondition;
        }

        public final void setPipelineExecutionStartCondition(String pipelineExecutionStartCondition) {
            this.pipelineExecutionStartCondition = pipelineExecutionStartCondition;
        }

        @Override
        public final Builder pipelineExecutionStartCondition(String pipelineExecutionStartCondition) {
            this.pipelineExecutionStartCondition = pipelineExecutionStartCondition;
            return this;
        }

        @Override
        public final Builder pipelineExecutionStartCondition(PipelineExecutionStartCondition pipelineExecutionStartCondition) {
            this.pipelineExecutionStartCondition(pipelineExecutionStartCondition == null ? null : pipelineExecutionStartCondition.toString());
            return this;
        }

        public final AutoDisablePolicy.Builder getAutoDisablePolicy() {
            return this.autoDisablePolicy != null ? this.autoDisablePolicy.toBuilder() : null;
        }

        public final void setAutoDisablePolicy(AutoDisablePolicy.BuilderImpl autoDisablePolicy) {
            this.autoDisablePolicy = autoDisablePolicy != null ? autoDisablePolicy.build() : null;
        }

        @Override
        public final Builder autoDisablePolicy(AutoDisablePolicy autoDisablePolicy) {
            this.autoDisablePolicy = autoDisablePolicy;
            return this;
        }

        public Schedule build() {
            return new Schedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Schedule> {
        public Builder scheduleExpression(String var1);

        public Builder timezone(String var1);

        public Builder pipelineExecutionStartCondition(String var1);

        public Builder pipelineExecutionStartCondition(PipelineExecutionStartCondition var1);

        public Builder autoDisablePolicy(AutoDisablePolicy var1);

        default public Builder autoDisablePolicy(Consumer<AutoDisablePolicy.Builder> autoDisablePolicy) {
            return this.autoDisablePolicy((AutoDisablePolicy)((AutoDisablePolicy.Builder)AutoDisablePolicy.builder().applyMutation(autoDisablePolicy)).build());
        }
    }
}

