/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecution;

public class ListWaitingWorkflowStepsIterable
implements SdkIterable<ListWaitingWorkflowStepsResponse> {
    private final ImagebuilderClient client;
    private final ListWaitingWorkflowStepsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWaitingWorkflowStepsIterable(ImagebuilderClient client, ListWaitingWorkflowStepsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWaitingWorkflowStepsResponseFetcher();
    }

    public Iterator<ListWaitingWorkflowStepsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowStepExecution> steps() {
        Function<ListWaitingWorkflowStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.steps() != null) {
                return response.steps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWaitingWorkflowStepsResponseFetcher
    implements SyncPageFetcher<ListWaitingWorkflowStepsResponse> {
        private ListWaitingWorkflowStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListWaitingWorkflowStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWaitingWorkflowStepsResponse nextPage(ListWaitingWorkflowStepsResponse previousPage) {
            if (previousPage == null) {
                return ListWaitingWorkflowStepsIterable.this.client.listWaitingWorkflowSteps(ListWaitingWorkflowStepsIterable.this.firstRequest);
            }
            return ListWaitingWorkflowStepsIterable.this.client.listWaitingWorkflowSteps((ListWaitingWorkflowStepsRequest)((Object)ListWaitingWorkflowStepsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

