/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowVersion;

public class ListWorkflowsIterable
implements SdkIterable<ListWorkflowsResponse> {
    private final ImagebuilderClient client;
    private final ListWorkflowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowsIterable(ImagebuilderClient client, ListWorkflowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkflowsResponseFetcher();
    }

    public Iterator<ListWorkflowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowVersion> workflowVersionList() {
        Function<ListWorkflowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowVersionList() != null) {
                return response.workflowVersionList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowsResponseFetcher
    implements SyncPageFetcher<ListWorkflowsResponse> {
        private ListWorkflowsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowsResponse nextPage(ListWorkflowsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowsIterable.this.client.listWorkflows(ListWorkflowsIterable.this.firstRequest);
            }
            return ListWorkflowsIterable.this.client.listWorkflows((ListWorkflowsRequest)((Object)ListWorkflowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

