/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecution;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsResponse;

public class ListLifecycleExecutionsPublisher
implements SdkPublisher<ListLifecycleExecutionsResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListLifecycleExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLifecycleExecutionsPublisher(ImagebuilderAsyncClient client, ListLifecycleExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLifecycleExecutionsPublisher(ImagebuilderAsyncClient client, ListLifecycleExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLifecycleExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLifecycleExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LifecycleExecution> lifecycleExecutions() {
        Function<ListLifecycleExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lifecycleExecutions() != null) {
                return response.lifecycleExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLifecycleExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLifecycleExecutionsResponseFetcher
    implements AsyncPageFetcher<ListLifecycleExecutionsResponse> {
        private ListLifecycleExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLifecycleExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLifecycleExecutionsResponse> nextPage(ListLifecycleExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListLifecycleExecutionsPublisher.this.client.listLifecycleExecutions(ListLifecycleExecutionsPublisher.this.firstRequest);
            }
            return ListLifecycleExecutionsPublisher.this.client.listLifecycleExecutions((ListLifecycleExecutionsRequest)((Object)ListLifecycleExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

