/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResource;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesResponse;

public class ListLifecycleExecutionResourcesPublisher
implements SdkPublisher<ListLifecycleExecutionResourcesResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListLifecycleExecutionResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLifecycleExecutionResourcesPublisher(ImagebuilderAsyncClient client, ListLifecycleExecutionResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLifecycleExecutionResourcesPublisher(ImagebuilderAsyncClient client, ListLifecycleExecutionResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLifecycleExecutionResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLifecycleExecutionResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LifecycleExecutionResource> resources() {
        Function<ListLifecycleExecutionResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLifecycleExecutionResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLifecycleExecutionResourcesResponseFetcher
    implements AsyncPageFetcher<ListLifecycleExecutionResourcesResponse> {
        private ListLifecycleExecutionResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListLifecycleExecutionResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLifecycleExecutionResourcesResponse> nextPage(ListLifecycleExecutionResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListLifecycleExecutionResourcesPublisher.this.client.listLifecycleExecutionResources(ListLifecycleExecutionResourcesPublisher.this.firstRequest);
            }
            return ListLifecycleExecutionResourcesPublisher.this.client.listLifecycleExecutionResources((ListLifecycleExecutionResourcesRequest)((Object)ListLifecycleExecutionResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

