/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Filter> {
    private static final SdkField<String> ATTRIBUTE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributePath").getter(Filter.getter(Filter::attributePath)).setter(Filter.setter(Builder::attributePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributePath").build()}).build();
    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeValue").getter(Filter.getter(Filter::attributeValue)).setter(Filter.setter(Builder::attributeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_PATH_FIELD, ATTRIBUTE_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Filter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attributePath;
    private final String attributeValue;

    private Filter(BuilderImpl builder) {
        this.attributePath = builder.attributePath;
        this.attributeValue = builder.attributeValue;
    }

    public final String attributePath() {
        return this.attributePath;
    }

    public final String attributeValue() {
        return this.attributeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.attributePath(), other.attributePath()) && Objects.equals(this.attributeValue(), other.attributeValue());
    }

    public final String toString() {
        return ToString.builder((String)"Filter").add("AttributePath", (Object)this.attributePath()).add("AttributeValue", (Object)(this.attributeValue() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributePath": {
                return Optional.ofNullable(clazz.cast(this.attributePath()));
            }
            case "AttributeValue": {
                return Optional.ofNullable(clazz.cast(this.attributeValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AttributePath", ATTRIBUTE_PATH_FIELD);
        map.put("AttributeValue", ATTRIBUTE_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributePath;
        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            this.attributePath(model.attributePath);
            this.attributeValue(model.attributeValue);
        }

        public final String getAttributePath() {
            return this.attributePath;
        }

        public final void setAttributePath(String attributePath) {
            this.attributePath = attributePath;
        }

        @Override
        public final Builder attributePath(String attributePath) {
            this.attributePath = attributePath;
            return this;
        }

        public final String getAttributeValue() {
            return this.attributeValue;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public Filter build() {
            return new Filter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Filter> {
        public Builder attributePath(String var1);

        public Builder attributeValue(String var1);
    }
}

