/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Name
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Name> {
    private static final SdkField<String> FORMATTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Formatted").getter(Name.getter(Name::formatted)).setter(Name.setter(Builder::formatted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Formatted").build()}).build();
    private static final SdkField<String> FAMILY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FamilyName").getter(Name.getter(Name::familyName)).setter(Name.setter(Builder::familyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FamilyName").build()}).build();
    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GivenName").getter(Name.getter(Name::givenName)).setter(Name.setter(Builder::givenName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()}).build();
    private static final SdkField<String> MIDDLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MiddleName").getter(Name.getter(Name::middleName)).setter(Name.setter(Builder::middleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MiddleName").build()}).build();
    private static final SdkField<String> HONORIFIC_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HonorificPrefix").getter(Name.getter(Name::honorificPrefix)).setter(Name.setter(Builder::honorificPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HonorificPrefix").build()}).build();
    private static final SdkField<String> HONORIFIC_SUFFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HonorificSuffix").getter(Name.getter(Name::honorificSuffix)).setter(Name.setter(Builder::honorificSuffix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HonorificSuffix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMATTED_FIELD, FAMILY_NAME_FIELD, GIVEN_NAME_FIELD, MIDDLE_NAME_FIELD, HONORIFIC_PREFIX_FIELD, HONORIFIC_SUFFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Name.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String formatted;
    private final String familyName;
    private final String givenName;
    private final String middleName;
    private final String honorificPrefix;
    private final String honorificSuffix;

    private Name(BuilderImpl builder) {
        this.formatted = builder.formatted;
        this.familyName = builder.familyName;
        this.givenName = builder.givenName;
        this.middleName = builder.middleName;
        this.honorificPrefix = builder.honorificPrefix;
        this.honorificSuffix = builder.honorificSuffix;
    }

    public final String formatted() {
        return this.formatted;
    }

    public final String familyName() {
        return this.familyName;
    }

    public final String givenName() {
        return this.givenName;
    }

    public final String middleName() {
        return this.middleName;
    }

    public final String honorificPrefix() {
        return this.honorificPrefix;
    }

    public final String honorificSuffix() {
        return this.honorificSuffix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatted());
        hashCode = 31 * hashCode + Objects.hashCode(this.familyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.givenName());
        hashCode = 31 * hashCode + Objects.hashCode(this.middleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.honorificPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.honorificSuffix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Name)) {
            return false;
        }
        Name other = (Name)obj;
        return Objects.equals(this.formatted(), other.formatted()) && Objects.equals(this.familyName(), other.familyName()) && Objects.equals(this.givenName(), other.givenName()) && Objects.equals(this.middleName(), other.middleName()) && Objects.equals(this.honorificPrefix(), other.honorificPrefix()) && Objects.equals(this.honorificSuffix(), other.honorificSuffix());
    }

    public final String toString() {
        return ToString.builder((String)"Name").add("Formatted", (Object)(this.formatted() == null ? null : "*** Sensitive Data Redacted ***")).add("FamilyName", (Object)(this.familyName() == null ? null : "*** Sensitive Data Redacted ***")).add("GivenName", (Object)(this.givenName() == null ? null : "*** Sensitive Data Redacted ***")).add("MiddleName", (Object)(this.middleName() == null ? null : "*** Sensitive Data Redacted ***")).add("HonorificPrefix", (Object)(this.honorificPrefix() == null ? null : "*** Sensitive Data Redacted ***")).add("HonorificSuffix", (Object)(this.honorificSuffix() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Formatted": {
                return Optional.ofNullable(clazz.cast(this.formatted()));
            }
            case "FamilyName": {
                return Optional.ofNullable(clazz.cast(this.familyName()));
            }
            case "GivenName": {
                return Optional.ofNullable(clazz.cast(this.givenName()));
            }
            case "MiddleName": {
                return Optional.ofNullable(clazz.cast(this.middleName()));
            }
            case "HonorificPrefix": {
                return Optional.ofNullable(clazz.cast(this.honorificPrefix()));
            }
            case "HonorificSuffix": {
                return Optional.ofNullable(clazz.cast(this.honorificSuffix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Formatted", FORMATTED_FIELD);
        map.put("FamilyName", FAMILY_NAME_FIELD);
        map.put("GivenName", GIVEN_NAME_FIELD);
        map.put("MiddleName", MIDDLE_NAME_FIELD);
        map.put("HonorificPrefix", HONORIFIC_PREFIX_FIELD);
        map.put("HonorificSuffix", HONORIFIC_SUFFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Name, T> g) {
        return obj -> g.apply((Name)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String formatted;
        private String familyName;
        private String givenName;
        private String middleName;
        private String honorificPrefix;
        private String honorificSuffix;

        private BuilderImpl() {
        }

        private BuilderImpl(Name model) {
            this.formatted(model.formatted);
            this.familyName(model.familyName);
            this.givenName(model.givenName);
            this.middleName(model.middleName);
            this.honorificPrefix(model.honorificPrefix);
            this.honorificSuffix(model.honorificSuffix);
        }

        public final String getFormatted() {
            return this.formatted;
        }

        public final void setFormatted(String formatted) {
            this.formatted = formatted;
        }

        @Override
        public final Builder formatted(String formatted) {
            this.formatted = formatted;
            return this;
        }

        public final String getFamilyName() {
            return this.familyName;
        }

        public final void setFamilyName(String familyName) {
            this.familyName = familyName;
        }

        @Override
        public final Builder familyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public final String getGivenName() {
            return this.givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final String getMiddleName() {
            return this.middleName;
        }

        public final void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        @Override
        public final Builder middleName(String middleName) {
            this.middleName = middleName;
            return this;
        }

        public final String getHonorificPrefix() {
            return this.honorificPrefix;
        }

        public final void setHonorificPrefix(String honorificPrefix) {
            this.honorificPrefix = honorificPrefix;
        }

        @Override
        public final Builder honorificPrefix(String honorificPrefix) {
            this.honorificPrefix = honorificPrefix;
            return this;
        }

        public final String getHonorificSuffix() {
            return this.honorificSuffix;
        }

        public final void setHonorificSuffix(String honorificSuffix) {
            this.honorificSuffix = honorificSuffix;
        }

        @Override
        public final Builder honorificSuffix(String honorificSuffix) {
            this.honorificSuffix = honorificSuffix;
            return this;
        }

        public Name build() {
            return new Name(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Name> {
        public Builder formatted(String var1);

        public Builder familyName(String var1);

        public Builder givenName(String var1);

        public Builder middleName(String var1);

        public Builder honorificPrefix(String var1);

        public Builder honorificSuffix(String var1);
    }
}

