/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.identitystore.model.IdentitystoreRequest;
import software.amazon.awssdk.services.identitystore.model.MemberId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupMembershipsForMemberRequest
extends IdentitystoreRequest
implements ToCopyableBuilder<Builder, ListGroupMembershipsForMemberRequest> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityStoreId").getter(ListGroupMembershipsForMemberRequest.getter(ListGroupMembershipsForMemberRequest::identityStoreId)).setter(ListGroupMembershipsForMemberRequest.setter(Builder::identityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()}).build();
    private static final SdkField<MemberId> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemberId").getter(ListGroupMembershipsForMemberRequest.getter(ListGroupMembershipsForMemberRequest::memberId)).setter(ListGroupMembershipsForMemberRequest.setter(Builder::memberId)).constructor(MemberId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListGroupMembershipsForMemberRequest.getter(ListGroupMembershipsForMemberRequest::maxResults)).setter(ListGroupMembershipsForMemberRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGroupMembershipsForMemberRequest.getter(ListGroupMembershipsForMemberRequest::nextToken)).setter(ListGroupMembershipsForMemberRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD, MEMBER_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGroupMembershipsForMemberRequest.memberNameToFieldInitializer();
    private final String identityStoreId;
    private final MemberId memberId;
    private final Integer maxResults;
    private final String nextToken;

    private ListGroupMembershipsForMemberRequest(BuilderImpl builder) {
        super(builder);
        this.identityStoreId = builder.identityStoreId;
        this.memberId = builder.memberId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String identityStoreId() {
        return this.identityStoreId;
    }

    public final MemberId memberId() {
        return this.memberId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupMembershipsForMemberRequest)) {
            return false;
        }
        ListGroupMembershipsForMemberRequest other = (ListGroupMembershipsForMemberRequest)((Object)obj);
        return Objects.equals(this.identityStoreId(), other.identityStoreId()) && Objects.equals(this.memberId(), other.memberId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupMembershipsForMemberRequest").add("IdentityStoreId", (Object)this.identityStoreId()).add("MemberId", (Object)this.memberId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityStoreId()));
            }
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdentityStoreId", IDENTITY_STORE_ID_FIELD);
        map.put("MemberId", MEMBER_ID_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGroupMembershipsForMemberRequest, T> g) {
        return obj -> g.apply((ListGroupMembershipsForMemberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IdentitystoreRequest.BuilderImpl
    implements Builder {
        private String identityStoreId;
        private MemberId memberId;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupMembershipsForMemberRequest model) {
            super(model);
            this.identityStoreId(model.identityStoreId);
            this.memberId(model.memberId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getIdentityStoreId() {
            return this.identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final MemberId.Builder getMemberId() {
            return this.memberId != null ? this.memberId.toBuilder() : null;
        }

        public final void setMemberId(MemberId.BuilderImpl memberId) {
            this.memberId = memberId != null ? memberId.build() : null;
        }

        @Override
        public final Builder memberId(MemberId memberId) {
            this.memberId = memberId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupMembershipsForMemberRequest build() {
            return new ListGroupMembershipsForMemberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IdentitystoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupMembershipsForMemberRequest> {
        public Builder identityStoreId(String var1);

        public Builder memberId(MemberId var1);

        default public Builder memberId(Consumer<MemberId.Builder> memberId) {
            return this.memberId((MemberId)((MemberId.Builder)MemberId.builder().applyMutation(memberId)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

