/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse;

public class ListRolePoliciesPublisher
implements SdkPublisher<ListRolePoliciesResponse> {
    private final IamAsyncClient client;
    private final ListRolePoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRolePoliciesPublisher(IamAsyncClient client, ListRolePoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRolePoliciesPublisher(IamAsyncClient client, ListRolePoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRolePoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRolePoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> policyNames() {
        return this.flatMapIterable(response -> response.policyNames());
    }

    private class ListRolePoliciesResponseFetcher
    implements AsyncPageFetcher<ListRolePoliciesResponse> {
        private ListRolePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListRolePoliciesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListRolePoliciesResponse> nextPage(ListRolePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListRolePoliciesPublisher.this.client.listRolePolicies(ListRolePoliciesPublisher.this.firstRequest);
            }
            return ListRolePoliciesPublisher.this.client.listRolePolicies((ListRolePoliciesRequest)((Object)ListRolePoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

