/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest;
import software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse;
import software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata;

public class ListSSHPublicKeysIterable
implements SdkIterable<ListSshPublicKeysResponse> {
    private final IamClient client;
    private final ListSshPublicKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSSHPublicKeysIterable(IamClient client, ListSshPublicKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSshPublicKeysResponseFetcher();
    }

    public Iterator<ListSshPublicKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SSHPublicKeyMetadata> sshPublicKeys() {
        Function<ListSshPublicKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.sshPublicKeys() != null) {
                return response.sshPublicKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSshPublicKeysResponseFetcher
    implements SyncPageFetcher<ListSshPublicKeysResponse> {
        private ListSshPublicKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListSshPublicKeysResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public ListSshPublicKeysResponse nextPage(ListSshPublicKeysResponse previousPage) {
            if (previousPage == null) {
                return ListSSHPublicKeysIterable.this.client.listSSHPublicKeys(ListSSHPublicKeysIterable.this.firstRequest);
            }
            return ListSSHPublicKeysIterable.this.client.listSSHPublicKeys((ListSshPublicKeysRequest)((Object)ListSSHPublicKeysIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

