/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveRoleFromInstanceProfileRequest
extends IamRequest
implements ToCopyableBuilder<Builder, RemoveRoleFromInstanceProfileRequest> {
    private static final SdkField<String> INSTANCE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileName").getter(RemoveRoleFromInstanceProfileRequest.getter(RemoveRoleFromInstanceProfileRequest::instanceProfileName)).setter(RemoveRoleFromInstanceProfileRequest.setter(Builder::instanceProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileName").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleName").getter(RemoveRoleFromInstanceProfileRequest.getter(RemoveRoleFromInstanceProfileRequest::roleName)).setter(RemoveRoleFromInstanceProfileRequest.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PROFILE_NAME_FIELD, ROLE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemoveRoleFromInstanceProfileRequest.memberNameToFieldInitializer();
    private final String instanceProfileName;
    private final String roleName;

    private RemoveRoleFromInstanceProfileRequest(BuilderImpl builder) {
        super(builder);
        this.instanceProfileName = builder.instanceProfileName;
        this.roleName = builder.roleName;
    }

    public final String instanceProfileName() {
        return this.instanceProfileName;
    }

    public final String roleName() {
        return this.roleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveRoleFromInstanceProfileRequest)) {
            return false;
        }
        RemoveRoleFromInstanceProfileRequest other = (RemoveRoleFromInstanceProfileRequest)((Object)obj);
        return Objects.equals(this.instanceProfileName(), other.instanceProfileName()) && Objects.equals(this.roleName(), other.roleName());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveRoleFromInstanceProfileRequest").add("InstanceProfileName", (Object)this.instanceProfileName()).add("RoleName", (Object)this.roleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceProfileName": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileName()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceProfileName", INSTANCE_PROFILE_NAME_FIELD);
        map.put("RoleName", ROLE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoveRoleFromInstanceProfileRequest, T> g) {
        return obj -> g.apply((RemoveRoleFromInstanceProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String instanceProfileName;
        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveRoleFromInstanceProfileRequest model) {
            super(model);
            this.instanceProfileName(model.instanceProfileName);
            this.roleName(model.roleName);
        }

        public final String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveRoleFromInstanceProfileRequest build() {
            return new RemoveRoleFromInstanceProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveRoleFromInstanceProfileRequest> {
        public Builder instanceProfileName(String var1);

        public Builder roleName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

